<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

		$woo_custom_option_plugin =  get_option( 'woo_custom_option_plugin' );

		if($woo_custom_option_plugin == 1) {
			
			add_filter( 'woocommerce_add_cart_item',  'add_cart_item' , 20, 1 );

			// Load cart data per page load
			add_filter( 'woocommerce_get_cart_item_from_session', 'get_cart_item_from_session' , 20, 2 );

			// Get item data to display
			add_filter( 'woocommerce_get_item_data',  'get_item_data' , 10, 2 );

			// Add item data to the cart
			add_filter( 'woocommerce_add_cart_item_data',  'add_to_cart_product' , 10, 2 );

			// Validate when adding to cart
			add_filter( 'woocommerce_add_to_cart_validation',  'validate_add_cart_product' , 10, 3 );

			// Add meta to order
			add_action( 'woocommerce_add_order_item_meta',  'order_item_meta' , 10, 2 );
		
		}
		
		function add_to_cart_product( $cart_item_data,$product_id ) {
			
				
				if ( empty( $cart_item_data['options'] ) ) {
					
					$cart_item_data['options'] = array();
					
				}
				global $product;
				
				$the_product = get_product( $product_id );
				
				if ( is_object( $the_product ) ) {
					
					$tax_display_mode = get_option( 'woocommerce_tax_display_shop' );
					
					$display_price    = $tax_display_mode == 'incl' ? $the_product->get_price_including_tax() : $the_product->get_price_excluding_tax();
				
				} else {
					
					$display_price    = '';
					
				}
				
				$variations_id=$_POST['variation_id'];
		
				$array_options  = (array) get_post_meta( $variations_id, '_variation_custom_options', true );
				
				
				if(is_array($array_options[0])){	
			
					foreach ( $array_options as $options_knum => $options_min ) {
						
						foreach ( $options_min as $options_key => $options ) {
							
							$price_type = $options['price_type'];
							
							if( $options['type'] == 'custom_field' || $options['type'] == 'custom_textarea' )
							{
								foreach ( $options['options'] as $option_key => $option ) {
									
									if($price_type == 1)
									{
										$pp =  $option['price_pp'];
										
										$c_price =  $display_price*$pp/100;
										
										$data_price = $c_price;
										
									}
									else
									{
										$data_price =  $option['price'];
										
									}
									
									/* $val_post =  $_POST['phoen-variation-options'][sanitize_title( $option['label'] )];
									$val_post = str_replace('\"','"',$val_post);
									$val_post = str_replace("\'","'",$val_post); */
									
									$val_post =  $_POST[ strtolower( $options['phoen_uid'] ) ][ sanitize_title( $option_key ) ];
									
									if($val_post != '')
									{
										$data[] = array(
											'name'  => $option['label'],
											'value' => $val_post,
											'display' => $val_post,
											'price' => $data_price
										);
										
										$cart_item_data['options'] =  $data;
									}
									
								}
							}
							elseif( $options['type'] == 'custom_checkbox' )
							{
								
								foreach ( $options['options'] as $option_key => $option ) {
									
									if($price_type == 1)
									{
										$pp =  $option['price_pp'];
										
										$c_price =  $display_price*$pp/100;
										
										$data_price = $c_price;
										
									}
									else
									{
										$data_price =  $option['price'];
										
									}
									
									$val_post =  $_POST[ strtolower( $options['phoen_uid'] ) ][ sanitize_title( $option_key ) ];
									
									if($val_post != '')
									{
										$data[] = array(
											'name'  => $options['name'],
											'value' => $val_post,
											'display'	=> $val_post,
											'price' => $data_price
										);
										
										$cart_item_data['options'] =  $data;
										
									
									}
								}

							}
							elseif( $options['type'] == 'custom_radio' )
							{
								
								foreach ( $options['options'] as $option_key => $option ) {
									
									if($price_type == 1)
									{
										$pp =  $option['price_pp'];
										
										$c_price =  $display_price*$pp/100;
										
										$data_price = $c_price;
										
									}
									else
									{
										$data_price =  $option['price'];
										
									}
																
									$val_post =  $_POST[ strtolower( $options['phoen_uid'] ) ];
									
									$option_label=sanitize_title($option['label']);	
									
									if( $val_post != '' && $val_post ==  sanitize_title($option_label))
									{
										$data[] = array(
											'name'  => $options['name'],
											'value' => $val_post,
											'display'	=> $val_post,
											'price' => $data_price
										);
										
										$cart_item_data['options'] =  $data;
									}
								}

							}
							elseif( $options['type'] == 'custom_select' )
							{
								
								foreach ( $options['options'] as $option_key => $option ) {
									
									if($price_type == 1)
									{
										$pp =  $option['price_pp'];
										
										$c_price =  $display_price*$pp/100;
										
										$data_price = $c_price;
										
									}
									else
									{
										$data_price =  $option['price'];
										
									}
																
									$val_post =  $_POST[ strtolower( $options['phoen_uid'] ) ];							
									
									$option_label=sanitize_title($option['label']);	
							
									if( $val_post != '' && $val_post ==  $option_label)
									{
										$data[] = array(
											'name'  => $options['name'],
											'value' => $val_post,
											'display'	=> $val_post,
											'price' => $data_price
										);
										
										
										$cart_item_data['options'] =  $data;
									}
								}

							}
							elseif( $options['type'] == 'custom_file' )
							{
								foreach ( $options['options'] as $option_key => $option ) {
									
									if($price_type == 1)
									{
										$pp =  $option['price_pp'];
										
										$c_price =  $display_price*$pp/100;
										
										$data_price = $c_price;
										
									}
									else
									{
										$data_price =  $option['price'];
										
									}
									
									$val_post =  strtolower( $options['phoen_uid'] );
										
										$file=$_FILES[ $val_post ];
										
										$main_file=array(
												'name'=>$file['name'][$option_key],
												'type'=>$file['type'][$option_key],
												'tmp_name'=>$file['tmp_name'][$option_key],
												'error'=>$file['error'][$option_key],
												'size'=>$file['size'][$option_key]
												);
										
									if ( ! empty( $main_file) && ! empty( $main_file['name'] ) ) 
									{
										$movefile = handle_upload( $main_file );
										
										if ( empty( $movefile['error'] ) && ! empty( $movefile['file'] ) ) 
										{
											$value  = woocommerce_clean( $movefile['url'] );
											
											$data[] = array(
												'name'  => $option['label'],
												'value' => $value,
												'display'	=> basename( $value ),
												'price' => $data_price,
												'descr' => $option['descr']
											);
											
										}
										else 
										{	
											//$dataaa =  new WP_Error( 'addon-error', $movefile['error'] );
											
											$data = new WP_Error( 'error', sprintf( __( '"%s"  '.$movefile['error'].'', 'custom-options' ), $option['label'] ) );
										
											throw new Exception( wc_add_notice( $data->get_error_message(), 'error' ) );
							
											//$data_msg = 1;
											
											
										}
									}

								}						
									
									$cart_item_data['options'] =  $data;
																
							}
							elseif( $options['type'] == 'quantity_type' )
							{
								
								if( $options['qty_type'] === 'custom_field' )
								{
									
									foreach ( $options['options'] as $option_key => $option ) {
									
										if($price_type == 1)
										{
											
											$pp =  $option['price_pp'];
											
											$c_price =  $display_price*$pp/100;
											
											$data_price = $c_price;
											
										}
										else
										{
											$data_price =  $option['price'];
											
										}
										
										$val_post =  $_POST[ strtolower( $options['phoen_uid'] ) ][ sanitize_title( $option_key ) ];
										
										if($val_post != '')
										{
											$data[] = array(
												'name'  => $option['label'],
												'value' => $val_post,
												'display'	=> $val_post,
												'price' => $data_price*$val_post
											);
											
											$cart_item_data['options'] =  $data;
										}
										
									}
									
								}
								elseif( $options['qty_type'] === 'custom_select' )
								{
									
									foreach ( $options['options'] as $option_key => $option ) {
									
										if($price_type == 1)
										{
											$pp =  $option['price_pp'];
											
											$c_price =  $display_price*$pp/100;
											
											$data_price = sanitize_title( $option['label'] )*$c_price;
											
										}
										else
										{
											$data_price =  sanitize_title( $option['label'] )*$option['price'];
											
										}
																	
										$val_post =  $_POST[ strtolower( $options['phoen_uid'] ) ];		

										$option_label=sanitize_title($option['label']);	
										
										if( $val_post != '' && $val_post == sanitize_title( $option_label ) )
										{
											$data[] = array(
												'name'  => $options['name'],
												'value' => $val_post,
												'display'	=> $val_post,
												'price' => $data_price
											);
											
											/*  */
											$cart_item_data['options'] =  $data;
										}
									}

								}
								elseif( $options['qty_type'] === 'custom_checkbox' )
								{
									
									foreach ( $options['options'] as $option_key => $option ) {
									
										if($price_type == 1)
										{
											$pp =  $option['price_pp'];
											
											$c_price =  $display_price*$pp/100;
											
											$data_price = sanitize_title( $option['label'] )*$c_price;
											
										}
										else
										{
											$data_price =  sanitize_title( $option['label'] )*$option['price'];
											
										}
										
										$val_post =  $_POST[ strtolower( $options['phoen_uid'] ) ][ $option_key ];
										
										if($val_post != '')
										{
											$data[] = array(
												'name'  => $options['name'],
												'value' => $val_post,
												'display'	=> $val_post,
												'price' => $data_price
											);
											
											$cart_item_data['options'] =  $data;
											
											/* echo "<pre>";
											print_r($data);
											echo "</pre>"; */
										}
										
									}
								
								}
								elseif( $options['qty_type'] === 'custom_radio' )
								{
									 
									 foreach ( $options['options'] as $option_key => $option ) {
									
										if($price_type == 1)
										{
											$pp =  $option['price_pp'];
											
											$c_price =  $display_price*$pp/100;
											
											$data_price = sanitize_title( $option['label'] )*$c_price;
											
										}
										else
										{
											$data_price =  sanitize_title( $option['label'] )*$option['price'];
											
										}
																	
										$val_post =  $_POST[ strtolower( $options['phoen_uid'] ) ];
										
										$option_label=sanitize_title($option['label']);
										
										if( $val_post != '' && $val_post == sanitize_title( $option_label ) )
										{
											$data[] = array(
												'name'  => $options['name'],
												'value' => $val_post,
												'display'	=> $val_post,
												'price' => $data_price
											);
											
											$cart_item_data['options'] =  $data;
										}
										
									}
									 
								}
								
							}elseif( $options['type'] == 'color_picker' )
								{
									
									
										if($price_type == 1)
										{
											$pp =  $options['product_new_price'];
											
											$c_price =  $display_price*$pp/100;
											
											$data_price = $c_price;
											
										}
										else
										{
											$data_price =  $options['product_new_price'];
											
										}
										
										
										$val_post =  strtolower($options['phoen_uid']);
																			
										if( $val_post != '' )
										{
											$data[] = array(
												'name'  => $options['name'],
												'value' => $val_post,
												'display'	=> $val_post,
												'price' => $data_price
											);
											
											$cart_item_data['options'] =  $data;
										}

								}
								elseif( $options['type'] == 'datetime_picker' )
								{
																		
										if($price_type == 1)
										{
											$pp =  $options['product_new_price'];
											
											$c_price =  $display_price*$pp/100;
											
											$data_price = $c_price;
											
										}
										else
										{
											$data_price =  $options['product_new_price'];
											
										}
										
										if($options['datetime_show']=="double"){
											
											$uuiid=strtolower($options['phoen_uid']);
											
											$val_from =  $_POST[ strtolower( $uuiid )]['from'];
												$val_to =  $_POST[ strtolower( $uuiid ) ]['to'];
											
											if($val_from!="" && $val_to!=''){
												
												$val_post = '<strong>(From) :</strong>'. $val_from.'<strong> (To) :</strong>'. $val_to;
											}else{
												$val_post = '';
											}
											
											
										}else{
											$val_post =  $_POST[ strtolower( $options['phoen_uid'] ) ];
										}								
													
										if( $val_post!="" )
										{
											$data[] = array(
												'name'  => $options['name'],
												'value' => $val_post,
												'display'	=> $val_post,
												'price' => $data_price
											);
											
											$cart_item_data['options'] =  $data;
										}

								}elseif( $options['type'] == 'range_picker' )
								{
																	
										if($price_type == 1)
										{
											$pp =  $options['product_new_price'];
											
											$c_price =  $display_price*$pp/100;
											
											$data_price = $c_price;
											
										}
										else
										{
											$data_price =  $options['product_new_price'];
											
										}
										
										$val_post =  strtolower($options['phoen_uid']);
										
										$val_post_step =  $_POST[ $val_post ];
										
										if($options['rang_type']=="step"){
											
											$data_price=$data_price*$val_post_step;
											
										}
									
										if( isset($val_post ) && $val_post != '' )
										{
											$data[] = array(
												'name'  => $options['name'],
												'value' => $val_post_step,
												'display'	=> $val_post_step,
												'price' => $data_price
											);
											
											$cart_item_data['options'] =  $data;
										}

								}

						}
					}
				}
				
				return $cart_item_data;
					
		}
		

		function handle_upload( $file ) {
			
			include_once( ABSPATH . 'wp-admin/includes/file.php' );
			
			include_once( ABSPATH . 'wp-admin/includes/media.php' );
			
			add_filter( 'upload_dir', 'options_upload_dir' );
			
			$upload_overrides = array( 'test_form' => false );

			$movefile = wp_handle_upload( $file, $upload_overrides );

			remove_filter( 'upload_dir', 'options_upload_dir' );

			return $movefile;
		}

		function options_upload_dir( $pathdata ) {
			
			global $woocommerce;

			if ( empty( $pathdata['subdir'] ) ) {
			
				$pathdata['path']   = $pathdata['path'] . '/product_options_files_uploads/' . md5( $woocommerce->session->get_customer_id() );
				
				$pathdata['url']    = $pathdata['url']. '/product_options_files_uploads/' . md5( $woocommerce->session->get_customer_id() );
				
				$pathdata['subdir'] = '/product_options_files_uploads/' . md5( $woocommerce->session->get_customer_id() );
				
			}
			else
			{
				
				$subdir  = '/product_options_files_uploads/' . md5( $woocommerce->session->get_customer_id() );
				
				$pathdata['path']   = str_replace( $pathdata['subdir'], $subdir, $pathdata['path'] );
				
				$pathdata['url']    = str_replace( $pathdata['subdir'], $subdir, $pathdata['url'] );
				
				$pathdata['subdir'] = str_replace( $pathdata['subdir'], $subdir, $pathdata['subdir'] );
			
			}
			
			return $pathdata;
		}
			
		function validate_add_cart_product(  $passed, $product_id, $quantity ) {
			
			global $woocommerce;
			
			$variations_id=$_POST['variation_id'];
			
			$array_options  = (array) get_post_meta( $variations_id, '_variation_custom_options', true );
			
			
			if(is_array($array_options[0]) && $array_options[0] !=''){
				
				foreach ( $array_options as $options_knum => $options_min ) {
				
					foreach ( $options_min as $options_key => $options ) {
						
						if( $options['type'] == 'custom_field' || $options['type'] == 'custom_textarea' )
						{
							if( $options['required'] == 1  )
							{
											
								foreach ( $options['options'] as $option_key => $option ) {
									
									
									if(isset($_POST[$options['phoen_uid']])){
									
										$post_data =  $_POST[sanitize_title( $options['phoen_uid'] )][$option_key];
								
										if ( isset($post_data) && $post_data == "" && strlen( $post_data ) == 0 ) {
											
											$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $option['label'] ) );
											
											wc_add_notice( $data->get_error_message(), 'error' );
											
											$data_msg = 1;
										}
											
										
										
										if ( strlen( $post_data ) > $option['max'] && $option['max'] != '' ) {
											
											$data = new WP_Error( 'error', sprintf( __( 'The maximum allowed length for "%s" is %s letters.', 'phoen-variation-options' ), $option['label'], $option['max'] ) );
											
											wc_add_notice( $data->get_error_message(), 'error' );
											
											$data_msg = 1;
										}
										
									}else{
									
										$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $option['label'] ) );
										
										wc_add_notice( $data->get_error_message(), 'error' );
										
										$data_msg = 1;
							
									}
								}
									
							}
						
						}
						elseif( $options['type'] == 'custom_checkbox')
						{
							if( $options['required'] == 1  )
							{
								if(isset($_POST[ sanitize_title( $options['phoen_uid'] ) ])){
							
								$post_data =  $_POST[ sanitize_title( $options['phoen_uid'] ) ];
							
									if ( sizeof( $post_data ) == 0 ) {
										
										$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $options['name'] ) );
										
										wc_add_notice( $data->get_error_message(), 'error' );
										
										$data_msg = 1;
									}
									
								}else{
										$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $options['name'] ) );
											
										wc_add_notice( $data->get_error_message(), 'error' );
											
										$data_msg = 1;
								}
							}
						}
						elseif( $options['type'] == 'custom_radio')
						{
							if( $options['required'] == 1  )
							{
								if(isset($_POST[ sanitize_title( $options['phoen_uid'] ) ])){
							
									$post_data =  $_POST[ sanitize_title( $options['phoen_uid'] ) ];
									
									if (  isset($post_data) && sizeof( $post_data ) == 0 ) {
										
										$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $options['name'] ) );
										
										wc_add_notice( $data->get_error_message(), 'error' );
										
										$data_msg = 1;
									}
								
								}else{
										$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $options['name'] ) );
											
										wc_add_notice( $data->get_error_message(), 'error' );
											
										$data_msg = 1;
								}
							}
						}
						elseif( $options['type'] == 'custom_select' )
						{
							if( $options['required'] == 1  )
							{
							
								if(isset($_POST[ sanitize_title( $options['phoen_uid'] ) ])){
							
									$post_data =  $_POST[ sanitize_title( $options['phoen_uid'] ) ];
							
									if (  isset($post_data) && $post_data == '' && strlen( $post_data ) == 0 ) {
										
										$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $options['name'] ) );
										
										wc_add_notice( $data->get_error_message(), 'error' );
										
										$data_msg = 1;
									}
								
								}else{
										$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $options['name'] ) );
											
										wc_add_notice( $data->get_error_message(), 'error' );
											
										$data_msg = 1;
								}
							}
						}
						elseif( $options['type'] == 'custom_file' )
						{
							if( $options['required'] == 1  )
							{
								foreach ( $options['options'] as $option_key => $option ) {
								
									$post_data =  sanitize_title( $option['random'] );

									if (  isset( $_FILES[ $post_data ]['name']  ) && ( empty( $_FILES[ $post_data ] ) || empty( $_FILES[ $post_data ]['name']) ) )  {
										
										$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $option['label'] ) );
										
										wc_add_notice( $data->get_error_message(), 'error' );
										
										$data_msg = 1;
									}
								
								}						
							}	
						}
						elseif( $options['type'] == 'quantity_type' )
						{
							
							if( $options['qty_type'] === 'custom_field' )
							{
								
							
								foreach ( $options['options'] as $option_key => $option ) {
								
									if(isset($_POST[$options["phoen_uid"]])){
										
										$post_data =  $_POST[$options["phoen_uid"]][sanitize_title( $option_key )];

										if( $options['required'] == 1  )
										{
											
											if (  isset($post_data) && $post_data == "" && strlen( $post_data ) == 0 ) {
												
												$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $option['label'] ) );
												
												wc_add_notice( $data->get_error_message(), 'error' );
												
												$data_msg = 1;
											}
											
										}
										
										
										if ( $post_data > $option['max'] && $option['max'] != '' ) {
											
											$data = new WP_Error( 'error', sprintf( __( 'The maximum allowed quantity for "%s" is %s .', 'phoen-variation-options' ), $option['label'], $option['max'] ) );
											
											wc_add_notice( $data->get_error_message(), 'error' );
											
											$data_msg = 1;
										}
											
									}else{
										
										$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $option['label'] ) );
										
										wc_add_notice( $data->get_error_message(), 'error' );
										
										$data_msg = 1;
								
									}
								
								}
								
							}
							elseif( $options['qty_type'] === 'custom_select' )
							{
								if(isset($_POST[ sanitize_title( $options['phoen_uid'] ) ])){
							
									$post_data =  $_POST[ sanitize_title( $options['phoen_uid'] ) ];
									
									if( $options['required'] == 1  )
									{
										
										if (  isset($post_data) && $post_data == '' && strlen( $post_data ) == 0 ) {
											
											$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $options['name'] ) );
											
											wc_add_notice( $data->get_error_message(), 'error' );
											
											$data_msg = 1;
										}
										
									}
								}else{
										$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $options['name'] ) );
											
										wc_add_notice( $data->get_error_message(), 'error' );
											
										$data_msg = 1;
								}
								
							}
							elseif( $options['qty_type'] === 'custom_radio' || $options['qty_type'] === 'custom_checkbox' )
							{
								 
								 if(isset($_POST[ sanitize_title( $options['phoen_uid'] ) ])){
									
									$post_data =  $_POST[ sanitize_title( $options['phoen_uid'] ) ];
							
									if( $options['required'] == 1  )
									{
										
										if (  sizeof( $post_data ) == 0 ) {
											
											$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $options['name'] ) );
											
											wc_add_notice( $data->get_error_message(), 'error' );
											
											$data_msg = 1;
										}
										
									}
								}else{
										
									$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $options['name'] ) );
										
									wc_add_notice( $data->get_error_message(), 'error' );
										
									$data_msg = 1;
								}
								
							}
							
						}
						
						elseif( $options['type'] == 'color_picker')
						{	
						
								
							if( $options['required'] == 1  )
							{
								if(isset($_POST[ sanitize_title( $options['phoen_uid'] ) ])){
							
								$post_data =  $_POST[ sanitize_title( $options['phoen_uid'] ) ];
							
								
									if ( empty( $post_data ) ) {
										
										$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $options['name'] ) );
										
										wc_add_notice( $data->get_error_message(), 'error' );
										
										$data_msg = 1;
									}
									
								}else{
										$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $options['name'] ) );
											
										wc_add_notice( $data->get_error_message(), 'error' );
											
										$data_msg = 1;
								}
							}
						}
						elseif( $options['type'] == 'datetime_picker')
						{
							
							 if( $options['required'] == 1  )
							{
								if(isset($_POST[ sanitize_title( $options['phoen_uid'] ) ])){
									$phoen_name_main_jd=strtolower($options['phoen_uid']);
									$post_data =  $_POST["$phoen_name_main_jd"];
						
									if ( empty($post_data)) {
										
										$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $options['name'] ) );
										
										wc_add_notice( $data->get_error_message(), 'error' );
										
										$data_msg = 1;
									}
									
								}else{
									
										$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $options['name'] ) );
											
										wc_add_notice( $data->get_error_message(), 'error' );
											
										$data_msg = 1;
								}
							} 
						}elseif( $options['type'] == 'range_picker' )
						{
						
							// $post_data =  sanitize_title( $option['label'] );
							$post_data =  $_POST[ sanitize_title( $options['phoen_uid'] ) ];
							
							if( $options['required'] == 1  )
							{
								
								if ( empty($post_data) ) {					
							
									$data = new WP_Error( 'error', sprintf( __( '"%s" is a required field.', 'phoen-variation-options' ), $options['name'] ) );
									
									wc_add_notice( $data->get_error_message(), 'error' );
									
									$data_msg = 1;
								}
								
							}
								
						}
							
					}
				}
				
				if($data_msg == 1)
				{
					return false;
				}
				
				
				
				return $passed;
				
			}else{
				
				return $passed;
				
			}
		
		}
		
		function get_item_data( $other_data, $cart_item_data ) {
			
			if ( ! empty( $cart_item_data['options'] ) ) {
				
				foreach ( $cart_item_data['options'] as $options ) {
									
					$name = $options['name'];

					if ( $options['price'] != 0 ) {
						
						$name .= ' (' . woocommerce_price( get_product_addition_options_price ( $options['price'] ) ) . ')';
					
					}

					$other_data[] = array(
						'name'    => $name,
						'value'   => $options['value'],
						'display' => $options['display']
					);
				}
			}
			
			return $other_data;
		}
		
		
		function add_cart_item($cart_item_data) {
		
			if ( ! empty( $cart_item_data['options'] ) ) {

				$extra_cost = 0;

				foreach ( $cart_item_data['options'] as $options ) {
					
					if ( $options['price'] != 0 ) {
						
						$extra_cost += $options['price'];
						
					}
				}

				$cart_item_data['data']->adjust_price( $extra_cost );
			}

			return $cart_item_data;
		}
		
		
		function get_cart_item_from_session($cart_item_data, $values) {
			
			if ( ! empty( $values['options'] ) ) {
				
				$cart_item_data['options'] = $values['options'];
				
				$cart_item_data = add_cart_item( $cart_item_data );
				
			}
			return $cart_item_data;
		}

		
		function order_item_meta($item_id,$values) {
					
			if ( ! empty( $values['options'] ) ) {
				
				foreach ( $values['options'] as $options ) {

					//print_r($options);

					$name = $options['name'];
					
					if( $options['price'] < 0 )
					{
						
						$name .= ' ( minus ';
						
						//if ( $options['price'] != 0 ) {
						
							$name .= woocommerce_price( get_product_addition_options_price( $options['price'] ) ) . ')';
						//}
						
					}
					else
					{
						
						if ( $options['price'] != 0 ) {
						
							$name .=  ' (' .woocommerce_price( get_product_addition_options_price( $options['price'] ) ) . ')';
							
						}
					
					}
						
					

					woocommerce_add_order_item_meta( $item_id, $name, $options['value'] );
					
				}
			}
			
		}
		
		function get_product_addition_options_price( $price ) {
			
			global $product;

			if ( $price === '' || $price == '0' ) {
				
				return;
				
			}

			if ( is_object( $product ) ) {
				
				$tax_display_mode = get_option( 'woocommerce_tax_display_shop' );
				
				$display_price    = $tax_display_mode == 'incl' ? $product->get_price_including_tax( 1, $price ) : $product->get_price_excluding_tax( 1, $price );
			
			} else {
				
				$display_price = $price;
				
			}

			return $display_price;
		}

?>