jQuery(document).ready(function($) {
  woopt_show_action();
  woopt_show_conditional();
  woopt_time_picker();
  woopt_build_value();

  $('body').on('change', '.woopt_action', function() {
    var $current_action = $(this).closest('.woopt_action_td');
    woopt_show_action($current_action);
    woopt_build_value();
  });

  $('body').on('change', '.woopt_weekday', function() {
    woopt_build_value();
  });

  $('body').on('change', '.woopt_weekno', function() {
    woopt_build_value();
  });

  $('body').on('change', '.woopt_conditional', function() {
    var $current_conditional = $(this).closest('.woopt_conditional_item');
    woopt_show_conditional($current_conditional);
    woopt_build_value();
  });

  $('body').on('change', '.woopt_price', function() {
    woopt_build_value();
  });

  $('body').on('click', '.woopt_new_conditional', function(e) {
    var $current_conditionals = $(this).
        closest('.woopt_table').
        find('.woopt_conditionals');
    var data = {
      action: 'woopt_add_conditional',
      woopt_nonce: woopt_vars.woopt_nonce,
    };
    $.post(ajaxurl, data, function(response) {
      $current_conditionals.append(response);
      woopt_show_conditional();
    });
    e.preventDefault();
  });

  $('body').on('click', '.woopt_action_remove', function() {
    $(this).closest('.woopt_table').remove();
    woopt_build_value();
  });

  $('body').on('click', '.woopt_conditional_remove', function() {
    $(this).closest('.woopt_conditional_item').remove();
    woopt_build_value();
  });

  $('body').on('click', '.woopt_picker', function() {
    if ($(this).hasClass('woopt_date_time')) {
      $(this).wooptdpk({
        timepicker: true,
        onSelect: function(fd, d) {
          if (!d) {
            return;
          }
          woopt_build_value();
        },
      });
    }
    if ($(this).hasClass('woopt_date')) {
      $(this).wooptdpk({
        onSelect: function(fd, d) {
          if (!d) {
            return;
          }
          woopt_build_value();
        },
      });
    }
    if ($(this).hasClass('woopt_date_range')) {
      $(this).wooptdpk({
        range: true,
        multipleDatesSeparator: ' - ',
        onSelect: function(fd, d) {
          if (!d) {
            return;
          }
          woopt_build_value();
        },
      });
    }
    if ($(this).hasClass('woopt_date_multi')) {
      $(this).wooptdpk({
        multipleDates: 5,
        multipleDatesSeparator: ', ',
        onSelect: function(fd, d) {
          if (!d) {
            return;
          }
          woopt_build_value();
        },
      });
    }
    if ($(this).hasClass('woopt_time')) {
      $(this).wooptdpk({
        timepicker: true,
        onlyTimepicker: true,
        classes: 'only-time',
        onSelect: function(fd, d) {
          if (!d) {
            return;
          }
          woopt_build_value();
        },
      });
    }
  });
});

function woopt_time_picker() {
  jQuery('.woopt_date_time').wooptdpk({
    timepicker: true,
    onSelect: function(fd, d) {
      if (!d) {
        return;
      }
      woopt_build_value();
    },
  });
  jQuery('.woopt_date').wooptdpk({
    onSelect: function(fd, d) {
      if (!d) {
        return;
      }
      woopt_build_value();
    },
  });
  jQuery('.woopt_date_range').wooptdpk({
    range: true,
    multipleDatesSeparator: ' - ',
    onSelect: function(fd, d) {
      if (!d) {
        return;
      }
      woopt_build_value();
    },
  });
  jQuery('.woopt_date_multi').wooptdpk({
    multipleDates: 5,
    multipleDatesSeparator: ', ',
    onSelect: function(fd, d) {
      if (!d) {
        return;
      }
      woopt_build_value();
    },
  });
  jQuery('.woopt_time').wooptdpk({
    timepicker: true,
    onlyTimepicker: true,
    classes: 'only-time',
    onSelect: function(fd, d) {
      if (!d) {
        return;
      }
      woopt_build_value();
    },
  });
}

function woopt_show_action($current_action) {
  if (typeof $current_action !== 'undefined') {
    var show_field_action = $current_action.find('.woopt_action').
        find(':selected').
        data('show');
    $current_action.find('.woopt_hide').hide();
    $current_action.find('.woopt_show_if_' + show_field_action).show();
  } else {
    jQuery('.woopt_action_td').each(function() {
      var show_field_action = jQuery(this).
          find('.woopt_action').
          find(':selected').
          data('show');
      jQuery(this).find('.woopt_hide').hide();
      jQuery(this).find('.woopt_show_if_' + show_field_action).show();
    });
  }
}

function woopt_show_conditional($current_conditional) {
  if (typeof $current_conditional !== 'undefined') {
    var show_field_conditional = $current_conditional.find(
        '.woopt_conditional').find(':selected').data('show');
    $current_conditional.find('.woopt_hide').hide();
    $current_conditional.find('.woopt_show_if_' + show_field_conditional).
        show();
  } else {
    jQuery('.woopt_conditional_item').each(function() {
      var show_field_conditional = jQuery(this).
          find('.woopt_conditional').
          find(':selected').
          data('show');
      jQuery(this).find('.woopt_hide').hide();
      jQuery(this).find('.woopt_show_if_' + show_field_conditional).show();
    });
  }
}

function woopt_build_value() {
  jQuery('.woopt_table').each(function() {
    var $this = jQuery(this);
    var action = '';
    var conditional = '';
    var conditional_arr = new Array();
    $this.find('.woopt_conditional_item').each(function() {
      var $this_conditional = jQuery(this);
      var current_conditional = jQuery(this).find('.woopt_conditional').val();
      switch (current_conditional) {
        case 'date_range':
          conditional_arr.push(current_conditional + '>' +
              $this_conditional.find('.woopt_date_range').val());
          break;
        case 'date_multi':
          conditional_arr.push(current_conditional + '>' +
              $this_conditional.find('.woopt_date_multi').val());
          break;
        case 'date_on':
          conditional_arr.push(current_conditional + '>' +
              $this_conditional.find('.woopt_date').val());
          break;
        case 'date_before':
          conditional_arr.push(current_conditional + '>' +
              $this_conditional.find('.woopt_date').val());
          break;
        case 'date_after':
          conditional_arr.push(current_conditional + '>' +
              $this_conditional.find('.woopt_date').val());
          break;
        case 'date_time_before':
          conditional_arr.push(current_conditional + '>' +
              $this_conditional.find('.woopt_date_time').val());
          break;
        case 'date_time_after':
          conditional_arr.push(current_conditional + '>' +
              $this_conditional.find('.woopt_date_time').val());
          break;
        case 'date_even':
          conditional_arr.push(current_conditional + '>true');
          break;
        case 'date_odd':
          conditional_arr.push(current_conditional + '>true');
          break;
        case 'time_range':
          conditional_arr.push(current_conditional + '>' +
              $this_conditional.find('.woopt_time_start').val() + ' - ' +
              $this_conditional.find('.woopt_time_end').val());
          break;
        case 'time_before':
          conditional_arr.push(current_conditional + '>' +
              $this_conditional.find('.woopt_time_on').val());
          break;
        case 'time_after':
          conditional_arr.push(current_conditional + '>' +
              $this_conditional.find('.woopt_time_on').val());
          break;
        case 'weekly_every':
          conditional_arr.push(current_conditional + '>' +
              $this_conditional.find('.woopt_weekday').val());
          break;
        case 'week_no':
          conditional_arr.push(current_conditional + '>' +
              $this_conditional.find('.woopt_weekno').val());
          break;
        case 'every_day':
          conditional_arr.push(current_conditional + '>true');
          break;
      }
    });
    conditional = conditional_arr.join('&');
    action = $this.find('.woopt_action').val() + '|' +
        $this.find('.woopt_price').val() + '|' + conditional;
    $this.find('.woopt_action_val').val(action);
  });
}