jQuery(document).ready(function($) {
	if (typeof szbd_map !== 'undefined') {
		initialize();
		$('.szbdshortcode_id_title').html(szbd_map.title);
	}
	//Support for Elementor popups
	jQuery(document).on('elementor/popup/show', function() {
		if (typeof szbd_map !== 'undefined') {
			initialize();
			$('.szbdshortcode_id_title').html(szbd_map.title);
		}
	});
});

function initialize() {

	var color = szbd_map.color[0] !== '' ? szbd_map.color : ['#53c853'];

	var bounds;
	var interactive = szbd_map.interactive == 1 ? true : false;
	if (typeof szbd_map.maps[0] !== 'undefined' || szbd_map.radius != 0) {
		var mapOptions = {
			zoom: 15,
			mapTypeId: google.maps.MapTypeId.ROADMAP,
			disableDefaultUI: !interactive,
		};
		var element = document.getElementById("szbdshortcode_id");
		if (element !== null) {
			var new_map = new google.maps.Map(element, mapOptions);
			bounds = new google.maps.LatLngBounds();
			if (typeof szbd_map.maps[0] !== 'undefined') {
				new_map.setOptions('center', new google.maps.LatLng(szbd_map.maps[0].lat, szbd_map.maps[0].lng));
				var fillcolor;
				_.each(szbd_map.maps, function(map_, j) {
					var path = [];
					_.each(map_.array_latlng, function(map__, i) {
						path.push(new google.maps.LatLng(map__[0], map__[1]));
						bounds.extend(path[i]);
					});

					
					fillcolor = typeof color[j] !== 'undefined' ? color[j] : color[color.length -1];
					new google.maps.Polygon({
						map: new_map,
						paths: path,
						strokeColor: fillcolor,
						strokeOpacity: 0.35,
						//strokeWeight: 3,
						fillColor: fillcolor,
						fillOpacity: 0.35
					});
					new_map.fitBounds(bounds);
				});
			}
			if (szbd_map.radius != 0) {
				if (szbd_map.store_address_picked == 1) {
					draw_circle(szbd_map.store_loc, new_map, color, bounds);
				} else {
					var store_address = szbd_map.store_loc;
					var geocode_storeaddress = new google.maps.Geocoder();
					geocode_storeaddress.geocode({
							'address': store_address.store_address + ',' + store_address.store_postcode + ',' + store_address.store_city + ',' + store_address.store_state + ',' + store_address.store_country
						},
						function(results, status) {
							var ok_types = ["street_address", "subpremise", "premise", "establishment", "route"];
							if (status === 'OK' && findCommonElements(results[0].types, ok_types)) {
								draw_circle(results[0].geometry.location, new_map, color, bounds);
							}
						});
				}
			}
		}
	}
}

function draw_circle(center, map, color, bounds) {
	map.setOptions('center', center);
	var circle = new google.maps.Circle({
		strokeColor: color,
		strokeOpacity: 0.35,
		fillColor: color,
		fillOpacity: 0.35,
		map: map,
		center: center,
		radius: parseFloat(szbd_map.radius) * 1000
	});
	bounds.extend(new google.maps.LatLng(circle.getBounds().getNorthEast().lat(), circle.getBounds().getNorthEast().lng()));
	bounds.extend(new google.maps.LatLng(circle.getBounds().getSouthWest().lat(), circle.getBounds().getSouthWest().lng()));
	map.fitBounds(bounds);
}
// Helping methods
function findCommonElements(arr1, arr2) {
	return arr1.some(item => arr2.includes(item));
}
