<?php
/*
Plugin Name: Woocommerce Custom Fields For Variation Pro

Plugin URI: http://www.phoeniixx.com

Description: This plugin is designed to give your Ecommerce website the space to add customized options for your products.

Version: 1.2.5

Text Domain: phoen-variation-options

Domain Path: /i18n/languages/

Author: Phoeniixx Team

Author URI: http://www.phoeniixx.com

** WC requires at least: 2.6.0

** WC tested up to: 4.1.0

*/
ob_start();
 
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
* Check if WooCommerce is active
**/

	if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) 
	{
	 
		define("custom_Variation_Options_plugin_dir_url", esc_url( plugin_dir_url( __FILE__ ) ) );

		/**
		* Custom Tab for Product display with TinyMCE Editor
		* Outputs an extra tab to the default set of info tabs on the single product page.
		*/
		
		add_action('admin_head','phoen_scripts_for_custom');
		
		function phoen_scripts_for_custom(){
			
			wp_enqueue_media();	
			
			wp_enqueue_script('jquery');
			
		}

	
	add_action('admin_head','phoen_scripts_for_custom_option_new');
	
	add_action('wp_enqueue_scripts','phoen_scripts_for_custom_option_new');
	
	add_action('wp_enqueue_scripts','phoen_scripts_option_new');
	
	function phoen_scripts_option_new(){	
	
		wp_enqueue_script( 'custom-script-jquery-ui', custom_Variation_Options_plugin_dir_url . '/assets/js/jquery-ui.js', array( 'jquery' ), false, false ); 
		
		wp_enqueue_script( 'custom-script-datetimepicker', custom_Variation_Options_plugin_dir_url . 'assets/js/datetimepicker.js', array( 'jquery' ), false, false ); 	 

		wp_enqueue_style( 'custom-style-datetimepicker', custom_Variation_Options_plugin_dir_url . '/assets/css/datetimepicker.css'); 
		
	}
	function phoen_scripts_for_custom_option_new(){	
								 										
		wp_enqueue_script('jquery-ui-accordion');																						
		
		wp_enqueue_script( 'phoen-variation-options-js', custom_Variation_Options_plugin_dir_url . '/assets/js/admin.js', array( 'jquery' ) );
		
		wp_enqueue_style( 'custom-style-main-uuyt', custom_Variation_Options_plugin_dir_url . '/assets/css/phoen_main_css.css' , false, false); 

		wp_enqueue_script( 'custom-script-spectrum', custom_Variation_Options_plugin_dir_url . '/assets/js/spectrum.js', array( 'jquery' ), false, false );  

		wp_enqueue_style( 'custom-style-spectrum', custom_Variation_Options_plugin_dir_url . '/assets/css/spectrum.css'); 

		wp_enqueue_script( 'custom-script-options', custom_Variation_Options_plugin_dir_url . '/assets/js/options.js', array( 'jquery' ), false, true ); 	
		
		wp_enqueue_style( 'custom-style-rangeslider', custom_Variation_Options_plugin_dir_url . 'assets/css/nouislider.min.css');  
			
		wp_enqueue_script( 'custom-script-rangeslider', custom_Variation_Options_plugin_dir_url . '/assets/js/nouislider.min.js',array('jquery'),false,false);
		
		wp_enqueue_script( 'custom-script-wNumb', custom_Variation_Options_plugin_dir_url . '/assets/js/wNumb.js',array('jquery'),false,false);
		
		wp_enqueue_style( 'fafa-icon', 'https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css');	
		
		wp_enqueue_style( 'custom-style-jquery-ui', custom_Variation_Options_plugin_dir_url . '/assets/css/admin_jquery_css_backend.css'); 
							
	}   

	
		class Product_Custom_Options {
			
				public function __construct() {
					
					if ( is_admin() ) {
						
						
						add_action( 'woocommerce_product_after_variable_attributes', array( $this, 'phoen_custom_options_tab_options' ), 10, 3 );
						
						
						// add_action( 'wp_enqueue_scripts', array( $this, 'phoen_process_product_meta_mone' ), 10, 1 );						
												
						include_once( 'classes/class-admin.php' );
					
					}
					
						
						include_once( 'classes/class-product-page-options.php' );
						
						include_once( 'classes/class-product-add-to-cart.php' );
						
			
				}

				
				 /**
				 * Custom Tab Options
				 * Provides the input fields and add/remove buttons for custom tabs on the single product page.
				 */

				function phoen_custom_options_tab_options( $loop, $variation_data, $variation ) {
				
					global $post;
					
					$variation_id  = $variation->ID;
					$product_custom_options_added = array_filter( (array) get_post_meta( $variation_id, '_variation_custom_options', true ) );
			
					?>
						<div id="custom_tab_data_<?php echo $variation_id;?>" class="phoen_new_niyye panel woocommerce_options_panel wc-metaboxes-wrapper">
								
								<input type="button" class="phoen_add_new_section_<?php echo $variation_id;?>" value="Add section" />
									<input type="hidden" name="phoe_variation_id[]" value="<?php echo  $variation_id;?>" />
								<div id="custom_tab_data_options_<?php echo $variation_id;?>" class="phoen_min_uuyttr wc-metaboxes">
								
								<?php 
								
								if(!empty($product_custom_options_added) && is_array($product_custom_options_added)){
									
									foreach($product_custom_options_added as $main => $valuedu){
										
										$phoen_new_section_style=(array)get_option("phoen_new_section_style_product$variation_id");
											
										?>
										<div  class="woocommerce_product_option wc-metabox closed">
											<h3 class="phoen_accordian_uuy">
												<strong class="spjjeoou_new">Section Style &mdash; </strong>
												<select name="phoen_new_section_style[<?php echo $variation_id; ?>][<?php echo $main;?>][style]">
													<option value="normal"  <?php if($phoen_new_section_style[0]=='' || $phoen_new_section_style[$main]['style']=="normal"){ echo 'selected'; } ?>>Normal (clear)</option>
													<option class="accordion" value="accordion" <?php if($phoen_new_section_style[$main]['style']=="accordion"){ echo 'selected'; } ?>>Accordion</option>
												</select>
												<strong class="spjjeoou">Section Name &mdash; </strong>
												<input type="text" class="phoen_section_name" name="phoen_new_section_style[<?php echo $variation_id; ?>][<?php echo $main;?>][name]"  value="<?php echo $phoen_new_section_style[$main]['name'];?>"/>
												<button type="button" class="remove_option button"><?php _e( 'Remove', 'phoen-variation-options' ); ?></button>
												<div class="phoen_custom_option_handlediv handlediv" title="<?php _e( 'Click to toggle', 'phoen-variation-options' ); ?>"></div>
												<input type="hidden" name="product_option_position[<?php echo $variation_id; ?>][<?php echo $main; ?>]" class="product_option_position" value="<?php echo $main; ?>" />
											
											</h3>
											<div id="phoen_main_close_<?php echo $variation_id.$main; ?>" class="phoen_content_upper_main count_miner_<?php echo $variation_id; ?> wc-metabox-content" style="display:none;">											
												<?php
													
												$loop = 0;

												foreach ( $valuedu as  $option ) {
													
													include( 'custom_options_html.php' );
													
													
													$loop++;
												}
														
												?>
												<div class="phoen_append_new_rule_<?php echo $variation_id;?>"></div>
												<div class="toolbar">
													<button type="button" data-loop="<?php echo $main; ?>" class="button add_new_custom_option_<?php echo $variation_id;?> button-primary"><?php _e( 'New Custom Option', 'phoen-variation-options' ); ?></button>
												</div>
											</div>
										</div>		
										<script>
										jQuery('#phoen_main_close_<?php echo $variation_id.$main; ?>').sortable({
										
											items:'.woocommerce_product_option_main',
											
											cursor:'move',
											
											axis:'y',
											
											handle:'h3',
											
											scrollSensitivity:50,
											
											helper:function(e,ui){
												
												return ui;
												
											},
											
											start:function(event,ui){
												
												ui.item.css('border-style', 'dashed');
												
											},
											
											stop:function(event,ui){
												
												ui.item.removeAttr('style');
												
												options_row_indexes();
												
											}
											
											
										});
										</script>
										<?php
									}
									
								}
								
								?>
								</div>
							<script type="text/javascript">
								
									jQuery(document).on('click', '.phoen_image_one_<?php echo $variation_id;?>', function(event){
										
									event.preventDefault();
										var custom_uploader='';
										var data_id='';
										var attachment='';
										var new_url='';

										var random = Math.floor(Math.random()*1020);
										random='phoen_'+random;
										jQuery(this).attr("id",random);				
										if (custom_uploader) {
											
											custom_uploader.open();
											
											return;
											
										} 
										//Extend the wp.media object
										custom_uploader = wp.media.frames.file_frame = wp.media({
											
											title: 'Choose Image',
											button: {
												text: 'Choose Image'
											},
											multiple: false						
										});
											
										custom_uploader.on('select', function() {
									
											var selection = custom_uploader.state().get('selection');
											
											selection.map( function( attachment ) {
												
												attachment = attachment.toJSON();
										
												 new_url = attachment.url;		
											
											});
											
											jQuery('#'+random).val(new_url); 
											
										});
									
										custom_uploader.open();
								 
								});
								
									
							
							
								jQuery(function() {
						

									jQuery("#variable_product_options").on('click', '.phoen_add_new_section_<?php echo $variation_id;?>', function(){
										
											var loop = jQuery('#custom_tab_data_options_<?php echo $variation_id;?> .woocommerce_product_option').size();

											var html = '<?php
												
												ob_start();

												$loop='{loop}';
												
												include( 'classes/global_new_section.php' );
											
												$html = ob_get_clean();
											
												echo str_replace( array( "\n", "\r" ), '', str_replace( "'", '"', $html ) );
											
											?>';
											html = html.replace( /{loop}/g, loop );					
											jQuery('#custom_tab_data_options_<?php echo $variation_id;?>').append( html );
									
											jQuery('#phoen_main_close_<?php echo $variation_id; ?>'+loop).sortable({

												items:'.woocommerce_product_option_main',
												
												cursor:'move',
												
												axis:'y',
												
												handle:'h3',
												
												scrollSensitivity:50,
												
												helper:function(e,ui){
													
													return ui;
													
												},
												
												start:function(event,ui){
													
													ui.item.css('border-style', 'dashed');
													
												},
												
												stop:function(event,ui){
													
													ui.item.removeAttr('style');
													
													options_row_indexes();
													
												}
												
												
											});

											
									});
									
									jQuery('#custom_tab_data_<?php echo $variation_id;?>').on( 'click', '.add_new_custom_option_<?php echo $variation_id;?>', function() {
										
										var parent_id=jQuery(this).closest('.count_miner_<?php echo $variation_id; ?>').attr('id');
								
										var main= jQuery(this).attr('data-loop');
								
										var loop = jQuery('#'+parent_id+' '+'.woocommerce_product_option_main').size();
										
										var random = (Math.random()+' ').substring(5,10)+(Math.random()+' ').substring(5,10);
										//alert(loop);
										var html = '<?php
											
											ob_start();

											$option['name'] 			= '';
											
											$option['des'] 			= '';
											
											$option['required'] 		= '';
											
											$option['all_custom_use'] 		= '';
											
											$option['all_custom_s_h'] 		= '';
											
											$option['all_custom_s_h_aa'] 		= '';
											
											$option['all_custom_field_dd'] 		= '';
											
											$option['all_custom_field'] 		= '';
											
											$option['all_custom_con'] 		= '';
											
											$option['option_showf'] 	= '';
											
											$option['option_showaf'] 	= '';
											
											$option['price_type']    =  '';
											
											$option['type'] 			= 'custom';
											
											$option['options'] 		= array();
											
											$loop = "{loop}";
											
											$random = "{random}";
											
											$main = "{main}";
											
											$loop11 = '111';

											include( 'custom_options_html.php' );
										
											$html = ob_get_clean();
											
											echo str_replace( array( "\n", "\r" ), '', str_replace( "'", '"', $html ) );
										
										?>';
										html = html.replace( /{loop}/g, loop );
										
										html = html.replace( /{main}/g, main );
										
										html = html.replace( /{random}/g, random );
										
										jQuery('#'+parent_id+' '+'.phoen_append_new_rule_<?php echo $variation_id;?>').before( html );
										
										jQuery('.clear_class'+main+loop).val( '' );
									
									});
									
									
									jQuery('#custom_tab_data_<?php echo $variation_id;?>').on( 'click', '.remove_option', function() {

											var conf = confirm('<?php _e('Are you sure you want remove this option?', 'phoen-variation-options'); ?>');

											if (conf) {
												
												var option = jQuery(this).closest('.woocommerce_product_option');
												
												//alert( option );
												
												jQuery(option).find('input').val('');
												
												jQuery(option).find('.option_name input').removeAttr("required");
												
												jQuery(option).hide();
												
											}

											return false;
									});
									jQuery('#custom_tab_data_<?php echo $variation_id;?>').on( 'click', '.remove_option_inner', function() {

										var conf = confirm('<?php _e('Are you sure you want remove this option?', 'phoen-variation-options'); ?>');

										if (conf) {
											
											var option = jQuery(this).closest('.woocommerce_product_option_main');
											
											jQuery(option).find('.option_name input').removeAttr("required");
											//alert( option );
											
											jQuery(option).find('input').val('');
											
											jQuery(option).hide();
											
										}

										return false;
								});
									
									jQuery('#custom_tab_data_options_<?php echo $variation_id;?>').sortable({
										
										items:'.woocommerce_product_option',
										
										cursor:'move',
										
										axis:'y',
										
										handle:'h3',
										
										scrollSensitivity:50,
										
										helper:function(e,ui){
											
											return ui;
											
										},
										
										start:function(event,ui){
											
											ui.item.css('border-style', 'dashed');
											
										},
										
										stop:function(event,ui){
											
											ui.item.removeAttr('style');
											
											options_row_indexes();
											
										}
										
										
									});
									
									
									function options_row_indexes() {
										
											jQuery('#custom_tab_data_<?php echo $variation_id;?> .woocommerce_product_option').each(function(index, sel) {
					
												jQuery('.product_option_position', sel).val( parseInt( index ) ); 
											
											});
									
									};
									
									jQuery('#custom_tab_data_<?php echo $variation_id;?>').on( 'change', '.product_option_type', function() {
										
										var product_option_type = jQuery(this).val();
										
										if( product_option_type == 'custom_file' || product_option_type == 'custom_checkbox' || product_option_type == 'custom_radio' || product_option_type == 'custom_select'  )
										{
											
											if(product_option_type == 'custom_file'){
												
												jQuery(this).closest('.woocommerce_product_option_main').find('.product_option_default').hide();
												
											}else{
												
												jQuery(this).closest('.woocommerce_product_option_main').find('.product_option_default').show();
												
											}
											
											if(product_option_type == 'custom_radio' ||  product_option_type == 'custom_checkbox'){
												
												jQuery(this).closest('.woocommerce_product_option_main').find('.phoen_replace_image').show();
												
											}else{
												
												jQuery(this).closest('.woocommerce_product_option_main').find('.phoen_replace_image').hide();
												
											}
											jQuery(this).closest('.woocommerce_product_option_main').find('td.pheo_price_columnn').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('td.minmax_column, th.minmax_column').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.minmaxq_column').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('.qty_type_sh').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_pp').css("display","none");
					
											jQuery(this).closest('.woocommerce_product_option_main').find('tr.phoen_datetime_main').hide();
									
											jQuery(this).closest('.woocommerce_product_option_main').find('tr.phoen_range_main').hide();	
					
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_label').show();

											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_qp').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_columnn').show();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('.price_set_defaut').show();
									
											jQuery(this).closest('.woocommerce_product_option_main').find('td.data table').show();
											
										}else if(product_option_type == 'color_picker' ){
									
											jQuery(this).closest('.woocommerce_product_option_main').find('.product_option_default').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('td.data table').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('.phoen_option_desc_hide').show();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('td.pheo_price_columnn').show();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('td.minmax_column, th.minmax_column').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.minmaxq_column').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('.qty_type_sh').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_pp').css("display","none");
					
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_label').show();

											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_qp').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_columnn').show();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('tr.phoen_datetime_main').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('tr.phoen_range_main').hide();
											
											
										}else if(product_option_type == 'datetime_picker' ){
											
										
											jQuery(this).closest('.woocommerce_product_option_main').find('.product_option_default').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('.phoen_option_desc_hide').show();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('td.data table').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('td.pheo_price_columnn').show();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('tr.phoen_datetime_main').show();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('tr.phoen_range_main').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('td.minmax_column, th.minmax_column').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.minmaxq_column').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('.qty_type_sh').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_pp').css("display","none");
					
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_label').show();

											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_qp').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_columnn').show();
											
											
										}else if(product_option_type == 'range_picker' ){
											
											jQuery(this).closest('.woocommerce_product_option_main').find('.product_option_default').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('.phoen_option_desc_hide').show();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('td.data table').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('td.pheo_price_columnn').show();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('tr.phoen_range_main').show();
																		
											jQuery(this).closest('.woocommerce_product_option_main').find('tr.phoen_datetime_main').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('td.minmax_column, th.minmax_column').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.minmaxq_column').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('.qty_type_sh').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_pp').css("display","none");
					
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_label').show();

											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_qp').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_columnn').show();
											
											
										}
										else if( product_option_type == 'quantity_type' )
										{
											
											jQuery(this).closest('.woocommerce_product_option_main').find('.product_option_default').hide();
									
											jQuery(this).closest('.woocommerce_product_option_main').find('.price_set_defaut').show();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('.phoen_option_desc_hide').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('td.data table').show();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('td.pheo_price_columnn').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('tr.phoen_datetime_main').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('tr.phoen_range_main').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('tr.phoen_range_main').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('.option_qty_type').val('custom_field');
										
											jQuery(this).closest('.woocommerce_product_option_main').find('th.minmaxq_column').show();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('td.minmax_column').show();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.minmax_column').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('.qty_type_sh').show();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_pp').css("display","none");
					
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_label').show();

											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_qp').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_columnn').show();
											
										}
										else
										{
											
											jQuery(this).closest('.woocommerce_product_option_main').find('.product_option_default').hide();
									
											jQuery(this).closest('.woocommerce_product_option_main').find('.phoen_replace_image').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('.price_set_defaut').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('.phoen_option_desc_hide').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('td.data table').show();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('td.pheo_price_columnn').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('tr.phoen_datetime_main').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('tr.phoen_range_main').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('td.minmax_column, th.minmax_column').show();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.minmaxq_column').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('.qty_type_sh').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_pp').css("display","none");
					
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_label').show();

											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_column_qp').hide();
											
											jQuery(this).closest('.woocommerce_product_option_main').find('th.price_columnn').show();
													
										}
										
									});
									
									jQuery('#custom_tab_data_<?php echo $variation_id;?>').on( 'change', '.option_qty_type', function() {
										
										var option_qty_type = jQuery(this).val();
										
										var option_price_type = jQuery(this).closest('.woocommerce_product_option').find('.option_price_type').val();
										
										if( option_qty_type == 'custom_checkbox' || option_qty_type == 'custom_radio' || option_qty_type == 'custom_select'  )
										{
											
											jQuery(this).closest('.woocommerce_product_option').find('.product_option_default').show();
											
											jQuery(this).closest('.woocommerce_product_option').find('td.minmax_column, th.minmax_column').hide();
											
											jQuery(this).closest('.woocommerce_product_option').find('th.minmaxq_column').hide();
											
											jQuery(this).closest('.woocommerce_product_option').find('.product_option_label').removeAttr("type");
											
											jQuery(this).closest('.woocommerce_product_option').find('.product_option_label').prop('type', 'number');
											
											jQuery(this).closest('.woocommerce_product_option').find('.product_option_label').prop('min', '1');
											
											jQuery(this).closest('.woocommerce_product_option').find('th.price_column_pp').hide();
					
											jQuery(this).closest('.woocommerce_product_option').find('th.price_column_label').hide();
											
											jQuery(this).closest('.woocommerce_product_option').find('th.price_columnn').hide();

											jQuery(this).closest('.woocommerce_product_option').find('th.price_column_qp').show();
											
											
										}
										else
										{
											
											jQuery(this).closest('.woocommerce_product_option').find('.product_option_default').hide();
											
											jQuery(this).closest('.woocommerce_product_option').find('td.minmax_column, th.minmax_column').show();
											
											jQuery(this).closest('.woocommerce_product_option').find('th.minmaxq_column').hide();
											
											jQuery(this).closest('.woocommerce_product_option').find('.product_option_label').removeAttr("type");
											
											jQuery(this).closest('.woocommerce_product_option').find('.product_option_label').prop('type', 'text');
											
											jQuery(this).closest('.woocommerce_product_option').find('.product_option_label').removeAttr("min");
											
											jQuery(this).closest('.woocommerce_product_option').find('th.price_column_pp').hide();
					
											jQuery(this).closest('.woocommerce_product_option').find('th.price_column_label').show();

											jQuery(this).closest('.woocommerce_product_option').find('th.price_column_qp').hide();
											
											jQuery(this).closest('.woocommerce_product_option').find('th.price_columnn').show();

										}
										
									});
									
									jQuery('#custom_tab_data_<?php echo $variation_id;?>').on( 'change', '.option_price_type', function() {
										
										var option_price_type =  jQuery(this).val();
										
										
										
										var 	option_qty_type = jQuery(this).closest('.woocommerce_product_option').find('.option_qty_type').val();
										
										var product_option_type = jQuery(this).closest('.woocommerce_product_option').find('.product_option_type').val();

										if( option_price_type == 1 )
										{
											
											jQuery(this).closest('.woocommerce_product_option').find('.price_column_pp').css("display","block");
											
											jQuery(this).closest('.woocommerce_product_option').find('.price_columnn').css("display","none");

											if(product_option_type == 'quantity_type' )
											{
												
												jQuery(this).closest('.woocommerce_product_option').find('th.price_column_qp').last().text('Per Quantity % Price');
												
												jQuery(this).closest('.woocommerce_product_option').find('th.price_column_pp').css("display","none");
												
												if( option_qty_type != 'custom_field' )
												{
													
													jQuery(this).closest('.woocommerce_product_option').find('th.minmax_column').css("display","none");

													jQuery(this).closest('.woocommerce_product_option').find('th.price_column_qp').css("display","");
													
													
												}
												else
												{
													
													jQuery(this).closest('.woocommerce_product_option').find('th.price_column_pp').css("display","block");

													jQuery(this).closest('.woocommerce_product_option').find('th.price_column_qp').css("display","none");
												}
												
											}
											
										}
										else
										{
											
											jQuery(this).closest('.woocommerce_product_option').find('.price_column_pp').css("display","none");
											
											jQuery(this).closest('.woocommerce_product_option').find('.price_columnn').css("display","block");
											
											if(product_option_type == 'quantity_type' )
											{
												
												jQuery(this).closest('.woocommerce_product_option').find('th.price_column_qp').last().text('Per Quantity Price');

												jQuery(this).closest('.woocommerce_product_option').find('th.price_columnn').css("display","none");
	
												if( option_qty_type != 'custom_field' )
												{
													
													jQuery(this).closest('.woocommerce_product_option').find('th.minmax_column').css("display","none");
													
													jQuery(this).closest('.woocommerce_product_option').find('th.price_column_qp').css("display","");
													
												}
												else
												{

													jQuery(this).closest('.woocommerce_product_option').find('th.price_column_qp').css("display","none");
													//jQuery(this).closest('.woocommerce_product_option').find('th.price_column_qp').css("display","");
													jQuery(this).closest('.woocommerce_product_option').find('.price_columnn').css("display","block");
													
												}
												
											}
											else
											{
												
												jQuery(this).closest('.woocommerce_product_option').find('.price_columnn').css("display","block");
											
												
											}
											
										}

									});
									
									jQuery('#custom_tab_data_<?php echo $variation_id;?>').on( 'click', '.add_all_custom_action', function() {
										
										var loop_count = jQuery(this).closest('.woocommerce_product_option_main').index('.woocommerce_product_option_main');

										var num_td_new= jQuery(this).attr('data-num');
										
										var num_loop= jQuery(this).attr('data-loop');
										
										var html = '<?php
											
											ob_start();

											$option['label'] 	= '';
											
											$option['price']	= '';
											
											$loop = "{loop}";
											
											$num_td_new = "{num_td_new}";
											
											$num_loop = "{num_loop}";

											include( 'custom_options_conditions_html.php' );
										
											$html = ob_get_clean();
											
											echo str_replace( array( "\n", "\r" ), '', str_replace( "'", '"', $html ) );
										
										?>';
										html = html.replace( /{loop}/g, loop_count );
										
										html = html.replace( /{num_td_new}/g, num_td_new );
										
										html = html.replace( /{num_loop}/g, num_loop );
										
										jQuery( html ).insertAfter( jQuery(this).closest('.woocommerce_product_option_main').find('.all_custom_con_main_div').last() );
										
										jQuery(this).closest('.woocommerce_product_option_main').find('.all_custom_field_dd option[value="'+jQuery( '#option_name_'+loop_count).val()+'"]').remove();
										
									});
									
									
									jQuery('#custom_tab_data_<?php echo $variation_id;?>').on( 'click', '.add_product_options', function() {
										
										var num_td =	jQuery(this).closest('#custom_tab_data_options_<?php echo $variation_id;?> .data').find('tbody tr').length;
										
										var parent_id=jQuery(this).closest('.count_miner_<?php echo $variation_id; ?>').attr('id');
										
										//var loop= jQuery('#'+parent_id+' '+'.woocommerce_product_option_main').length-1;
										
										var num_td_new= jQuery(this).attr('data-num');
										
										var random11 = (Math.random()+' ').substring(5,10)+(Math.random()+' ').substring(5,10);
										
										var loop= jQuery(this).attr('data-main');
										
										var html = '<?php
											
											ob_start();

											$option['label'] 	= '';
											
											$option['price']	= '';
											
											$loop = "{loop}";
											
											$random = "{random}";	
											
											$num_td = "{num_td}";
									
											$num_td_new = "{num_td_new}";
									
											include( 'custom_options_values_html.php' );
										
											$html = ob_get_clean();
											
											echo str_replace( array( "\n", "\r" ), '', str_replace( "'", '"', $html ) );
										
										?>';
										html = html.replace( /{loop}/g, loop );
										
										html = html.replace( /{num_td}/g, num_td );
										
										html = html.replace( /{random}/g, random11 );
								
										html = html.replace( /{num_td_new}/g, num_td_new );
										
										jQuery(this).closest('#custom_tab_data_options_<?php echo $variation_id;?> .data').find('tbody').append( html );

										var drop_val = jQuery(this).closest('.woocommerce_product_option_main').find('.product_option_type').val();
										
										var opt_price_type = jQuery(this).closest('.woocommerce_product_option').find('.option_price_type').val();

										var option_qty_type = jQuery(this).closest('.woocommerce_product_option').find('.option_qty_type').val();
										
										/* alert(drop_val); */
										
										if( drop_val == 'custom_file' || drop_val == 'custom_checkbox' || drop_val == 'custom_radio' )
										{
											
											
											if(drop_val == 'custom_file' ){
												
												jQuery(this).closest('.woocommerce_product_option').find('.product_option_default').hide();
												
											}else{
												
												jQuery(this).closest('.woocommerce_product_option').find('.product_option_default').show();
												
											}	
											if(drop_val !== 'custom_file' ){
												
												jQuery(this).closest('.woocommerce_product_option').find('.phoen_replace_image').show();
												
											}else{
												
												jQuery(this).closest('.woocommerce_product_option').find('.phoen_replace_image').hide();
												
											}			
											
											jQuery(this).closest('.woocommerce_product_option_main').find("td.minmax_column, th.minmax_column").hide();
										
											jQuery(this).closest('.woocommerce_product_option').find('th.minmaxq_column').hide();
											
											jQuery(this).closest('.woocommerce_product_option').find('.price_set_defaut').show();
											
											if( opt_price_type == 1 )
											{
												
												jQuery(this).closest('.woocommerce_product_option').find('.price_column_pp').show();
												
												jQuery(this).closest('.woocommerce_product_option').find('.price_columnn').hide();
											
											}
											else
											{
												
												jQuery(this).closest('.woocommerce_product_option').find('.price_columnn').show();
												
												jQuery(this).closest('.woocommerce_product_option').find('.price_column_pp').hide();
											
											}
											
										}
										else if( drop_val == 'quantity_type' )
										{

										//	jQuery(this).closest('.woocommerce_product_option').find('.product_option_default').show();
											
											jQuery(this).closest('.woocommerce_product_option').find('th.minmaxq_column').show();
											
											jQuery(this).closest('.woocommerce_product_option').find('td.minmax_column').show();
											
											jQuery(this).closest('.woocommerce_product_option').find('th.minmax_column').hide();
											
											jQuery(this).closest('.woocommerce_product_option').find('.qty_type_sh').show();

											var option_qty_type = jQuery(this).closest('.woocommerce_product_option').find('.option_qty_type').val();
											
											if( option_qty_type == 'custom_checkbox' || option_qty_type == 'custom_radio' || option_qty_type == 'custom_select'  )
											{
												
												if(option_qty_type !== 'custom_file' ){
												
													jQuery(this).closest('.woocommerce_product_option').find('.phoen_replace_image').show();
													
												}else{
													
													jQuery(this).closest('.woocommerce_product_option').find('.phoen_replace_image').hide();
													
												}		
												
												jQuery(this).closest('.woocommerce_product_option').find('.product_option_default').show();
												
												jQuery(this).closest('.woocommerce_product_option').find('td.minmax_column, th.minmax_column').hide();
												
												jQuery(this).closest('.woocommerce_product_option').find('th.minmaxq_column').hide();

												jQuery(this).closest('.woocommerce_product_option').find('.product_option_label').removeAttr("type");
																			
												jQuery(this).closest('.woocommerce_product_option').find('.product_option_label').prop('type', 'number');
												
												jQuery(this).closest('.woocommerce_product_option').find('.product_option_label').prop('min', '1');
												
												//jQuery(this).closest('.woocommerce_product_option').find('.price_column_pp').css("display","none");
												
												jQuery(this).closest('.woocommerce_product_option').find('th.price_column_label').hide();
												
												//jQuery(this).closest('.woocommerce_product_option').find('th.price_columnn').hide();

												jQuery(this).closest('.woocommerce_product_option').find('th.price_column_qp').show();
												
												if( opt_price_type == 1 )
												{
													
													jQuery(this).closest('.woocommerce_product_option').find('td.price_columnn').hide();
													
													jQuery(this).closest('.woocommerce_product_option').find('td.price_column_pp').show();
													
												}
												
											}
											else
											{
												
													jQuery(this).closest('.woocommerce_product_option').find('.product_option_default').hide();
												
												jQuery(this).closest('.woocommerce_product_option').find('.phoen_replace_image').hide();
												
												jQuery(this).closest('.woocommerce_product_option').find('td.minmax_column, th.minmax_column').show();
												
												jQuery(this).closest('.woocommerce_product_option').find('th.minmaxq_column').hide();
												
												jQuery(this).closest('.woocommerce_product_option').find('.product_option_label').removeAttr("type");
																		
												jQuery(this).closest('.woocommerce_product_option').find('.product_option_label').prop('type', 'text');
												
												jQuery(this).closest('.woocommerce_product_option').find('.product_option_label').removeAttr("min");
												
												//jQuery(this).closest('.woocommerce_product_option').find('.price_column_pp').show();
												
												jQuery(this).closest('.woocommerce_product_option').find('th.price_column_label').show();

												jQuery(this).closest('.woocommerce_product_option').find('th.price_column_qp').hide();
												
												//jQuery(this).closest('.woocommerce_product_option').find('th.price_columnn').show();

											}
											
										}
										else
										{
																				
											if(drop_val == 'custom_select' ){
												
												jQuery(this).closest('.woocommerce_product_option').find('.product_option_default').show();
												
											}else{
												
												jQuery(this).closest('.woocommerce_product_option').find('.product_option_default').hide();
												
											}									
																				
											jQuery(this).closest('.woocommerce_product_option').find('.phoen_replace_image').hide();
											
											jQuery(this).closest('.woocommerce_product_option').find('td.minmax_column, th.minmax_column').show();
											
											jQuery(this).closest('.woocommerce_product_option').find('th.minmaxq_column').hide();
											
											if( opt_price_type == 1 )
											{
												
												jQuery(this).closest('.woocommerce_product_option').find('.price_column_pp').show();
												
												jQuery(this).closest('.woocommerce_product_option').find('.price_columnn').hide();
											
											}
											else
											{
												
												jQuery(this).closest('.woocommerce_product_option').find('.price_columnn').show();
												
												jQuery(this).closest('.woocommerce_product_option').find('.price_column_pp').hide();
											
											}
										}

									});
									
									
									jQuery('button.remove_product_option_<?php echo $variation_id; ?>').live('click', function() {

											var answer = confirm('<?php _e('Are you sure you want to delete this option?', 'phoen-variation-options'); ?>');

											if (answer) {
												
												jQuery(this).closest('tr').remove();
												
											}

											return false;

									});
									
									jQuery('#variable_product_options .remove_all_custom_action_<?php echo $variation_id;?>').live('click',function() {

										var answer = confirm('<?php _e('Are you sure you want to delete this condition?', 'phoen-variation-options'); ?>');

											if (answer) {
												
												jQuery(this).closest('.all_custom_con_main_div').remove();
											
											}
											
											return false;

									});
		
								});
								
							</script>
							
							<style>
							#custom_tab_data_<?php echo $variation_id;?> input {
								
								min-width: 139px;
								
							}
							
							#custom_tab_data_<?php echo $variation_id;?> label {
								
								margin: 0;
								
							}
							
							#custom_tab_data_options_<?php echo $variation_id;?> .wc-metabox-content .option_required label {
								
								display: inline-block;
								
								float: none;
								
								margin-left: 4px;
								
								margin-right: 0;
								
								margin-top: 18px;
								
								text-align: left;
								
							}
								
							#custom_tab_data_options_<?php echo $variation_id;?> .wc-metabox-content	.option_required > input {
								
								display: inline-block !important;
								
								float: none !important;
								
								margin-left: 21px !important;
								
								margin-top: 20px !important;
												
							}	
												
							#custom_tab_data_options_<?php echo $variation_id;?> .wc-metabox-content	.option_required {
								
								vertical-align: middle !important;
											
							}						
							
							#custom_tab_data_options_<?php echo $variation_id;?> .wc-metabox-content .option_required input[type="checkbox"]{
							  
								width: 16px;

								min-width: 16px;

								display: block;

								margin: auto;

								float: none;
							  
							}
                            
							#fieldRulesTop.toolbar .all_custom_use  {
								float: none;
								margin-top: 15px;
								width: 30% !important;
								margin-bottom: 15px;
								vertical-align: inherit;
								display: block;
							} 
                            
                            #fieldRulesTop.toolbar .all_custom_s_h {
                                width: 20%!important;
                                margin-bottom: 15px;
                                vertical-align: inherit;
                                float: none;
                                
                            }
                            
                            #fieldRulesTop.toolbar .all_custom_s_h_aa {
                                width: 20%!important;
                                margin-bottom: 15px;
                                vertical-align: inherit;
                                float: none;
                            }
                            
                                                        
                            #fieldRulesTop.toolbar .all_custom_field_dd {
                                width: 31%!important;
                                margin-bottom: 15px;
                                vertical-align: inherit;
                                float: none;
                                
                            }
                            
                           #fieldRulesTop.toolbar .all_custom_con {
                                width: 31%!important;
                                margin-bottom: 15px;
                                vertical-align: inherit;
                                float: none;
                                margin-left: 5px;
                           }
                           
                           #fieldRulesTop.toolbar .all_custom_field {
                                width: 24%!important;
                                margin-bottom: 15px;
                                vertical-align: inherit;
                                float: none;
                                margin-left: 5px;
                                    
                           }
                           
                           #fieldRulesTop.toolbar .all_custom_con_main_div {
                                display: inline;
                           }
                           
                           #fieldRulesTop.toolbar .all_custom_value_div {
                                display: inline;
                           }
                           
                           #fieldRulesTop.toolbar .all_custom_con_div {
                                display: inline;
                           }
                           
                           #fieldRulesTop.toolbar .all_custom_action_cross_div {
                                display: inline;
                                
                           }
                           
                           #fieldRulesTop.toolbar .all_custom_action_add_div {
                                display: inline;
                            
                           }
						   
							</style>
						</div>
					<?php
				
				}
				
		}
		
		$Product_Custom_Options_obj = new Product_Custom_Options();
        
        
        add_action('wp_head','header_function');
        
        function header_function()
        {
            
            ?>
				<style>
				
					.product-option-div h3 {margin-bottom: 0;}
					.product-option-div .option_des p {font-size: 13px!important; word-break: break-all;}
					
				</style>
				<script>
				
				jQuery( document ).ready( function($) {
					
					/* jQuery('.variations select').val('');
					
					jQuery(".variation_id").val(''); */
					
					
					
					main_col();
					
					var variation_id=0;
					
					//setTimeout(main_col, 100);
					
					jQuery(".reset_variations,.variations select").on('change',function(){
						setTimeout(main_col, 100);
					});
						
							
					function main_col () {
						
						 variation_id = jQuery(".variation_id").val();
						 
						// alert(variation_id);
						 
						 jQuery('#product-options-total').html( '' );
						 
						if(variation_id!=='' && variation_id !==undefined && variation_id !==0){
							jQuery('.phoen_kmte').each(function(){
								if(jQuery(this).hasClass('phoen_new_'+variation_id)){
									
									jQuery(this).css('display','block');
									
									jQuery(this).trigger( 'show_options_final_total' );
									
								}else{
									jQuery(this).css('display','none');
								}
							});
						}else{
							
							jQuery('.phoen_kmte').each(function(){
								jQuery(this).css('display','none');
							});
						}	
					}
					
					
					(function(){
							
						var i=0;
						
						$('.phoen_main_add_cart').each( function() {
							
							if($(this).hasClass('custom_raio')){
								
								var fb_name=$(this).attr('name');
								var val_phoen=$("input[name='"+fb_name+"']:checked").val();
								
								if (val_phoen != '' && val_phoen != undefined ) {
									$(this).removeClass("phoen_main_add_cart");
								}else{
									jQuery(".woocommerce div.product form.cart .single_add_to_cart_button").prop("disabled",true);	
								}
								
							}else if($(this).hasClass('custom_checkbox')){
								
								if($(this).hasClass("phoen_custom_options_"+i+"")){
									var val_phoen=$("input:checkbox.phoen_custom_options_"+i+":checked").length;
									if (val_phoen > 0 && val_phoen != undefined ) {
										$(".phoen_custom_options_"+i+"").each(function (){
											
											$(this).removeClass("phoen_main_add_cart");
											
										});	
									}else{
										jQuery(".woocommerce div.product form.cart .single_add_to_cart_button").prop("disabled",true);	
									}
									
								}
								
							}else if($(this).hasClass('custom_field') || $(this).hasClass('custom_textarea') || $(this).hasClass('custom_file')){
								var new_main='';
								if($(this).hasClass("text_custom_"+i+"")){
									
									
									$(".text_custom_"+i+"").each(function(){
										if($(this).val() !==''){
											 new_main=$(this).val();
										}
									})
																		
									if (new_main !=='' && new_main != undefined ) {
										$(".text_custom_"+i+"").each(function (){
											
											$(this).removeClass("phoen_main_add_cart");
											
										});	
									}else{
										jQuery(".woocommerce div.product form.cart .single_add_to_cart_button").prop("disabled",true);	
									}
									
								}
								
							}else{
								if($(this).val() === ''){
									jQuery(".woocommerce div.product form.cart .single_add_to_cart_button").prop("disabled",true);	
								}else{
									$(this).removeClass("phoen_main_add_cart");
								}
							}
							
								i++;
						});
								
						
						var option_total = 0;

						var product_price = $(this).find( '#product-options-total' ).data( 'product-price' );
						
						if(typeof product_price == 'undefined' )
						{
							
							var product_price = $( '#product-options-total' ).attr( 'product-price' );
						
						}
						 
						product_price = parseFloat( product_price ); 
						  
						var product_total_price = 0;
						
						var final_total = 0;
						//custom_options_range-picker-title phoen_sstdcbmm phoen-variation-options custom_range
						$('.phoen-variation-options').each( function() {
							
							//alert('85yy');
							
							var option_price = 0;
							
							var value_entered =  $(this).val();
							
							if( $(this).is('.custom_field') )
							{
								
								if( value_entered != '' )
								{
									
									option_price = $(this).attr('data-price');
									
								}
								
							}
							else if( $(this).is('.custom_textarea') )
							{
								
								if( value_entered != '' )
								{
									
									option_price = $(this).attr('data-price');
									
								}
								
							}
							else if( $(this).is('.custom_checkbox') )
							{
								
								if ( $(this).is(':checked') )
								{
									
									option_price = $(this).attr('data-price');
									
								}
								
							}
							else if( $(this).is('.custom_raio') )
							{
								
								if ( $(this).is(':checked') )
								{
									
									option_price = $(this).attr('data-price');
									
								}
								
							}
							else if( $(this).is('.custom_select') )
							{
								if( value_entered != '' )
								{
									
									option_price = $(this).find('option:selected').attr('data-price');
								}
								
							}
							else if( $(this).is('.custom_quantity') )
							{
								
								if( value_entered != '' )
								{
									
									option_price =  $(this).attr('data-price') * value_entered;
									
								}
								
							}
							else if( $(this).is('.custom_range') )
							{
								if( value_entered != '' )
								{
									
									if($(this).attr('data-range') === "fixed"){
										
										option_price =  $(this).attr('data-price');
										
									}else{
										
										option_price =  $(this).attr('data-price') * value_entered;
										
									}
									
								}
								
							}
							else
							{
								
								if( value_entered != '' )
								{
									
									option_price = $(this).attr('data-price');
									
								}
								
							}
							
							if(value_entered != '' && option_price != 0)
							{
								
								option_total = parseFloat( option_total ) + parseFloat( option_price );
								
							}
							
						});
												
						var qty_div = $('.qty');

						if ( qty_div.length){
							var qty = qty_div.val();
						}else{
							var qty = 1;
						}
						
						//var qty = $('.qty').val();
						
						if ( option_total != 0 && qty > 0 ) {
							
							option_total = option_total * qty;
							
							option_total = option_total.toFixed(2); 
							
							option_total = parseFloat( option_total ); 
							
							if ( product_price ) {

								product_total_price = product_price * qty;
								
								product_total_price = product_total_price.toFixed(2); 
								
								product_total_price = parseFloat( product_total_price ); 
								
							}
														
							final_total = option_total + product_total_price;
							
							final_total = final_total.toFixed(2); 
														
							<?php 
							
							$decimale_separator = wc_get_price_decimal_separator();
							
							?>
							var decimale_separator = '<?php echo $decimale_separator;?>';
							
							if(decimale_separator != '.'){
								
								option_total = option_total.toString();
								
								option_total = option_total.replace('.',decimale_separator);
								
								final_total = final_total.replace('.',decimale_separator);
							}

							html = '';
							
							if(woocommerce_custom_options_params.show_op == 1)
							{
								
								html = html + '<dl class="product-options-price phoen_belo_head"><dt> ' + woocommerce_custom_options_params.op_show + '</dt><dd><strong><span class="amount">' + woocommerce_custom_options_params.currency_symbol+option_total + '</span></strong></dd>';
							
							}
							
							if ( final_total ) {
								
								if(woocommerce_custom_options_params.show_ft == 1)
								{
									
									html = html + '<dt>' + woocommerce_custom_options_params.ft_show + '</dt><dd><strong><span class="amount">' + woocommerce_custom_options_params.currency_symbol+final_total + '</span></strong></dd>';
								
								}

							}

							html = html + '</dl>';

							$('#product-options-total').html( html );
								
						} else {
							
							$('#product-options-total').html( '' );
						}
							
					})();
					
					
					$(this).on( 'show_options_final_total', function() {
						//alert(8875);
						
						var i=0;
						//alert(variation_id);
						$('.phoen_main_add_cart').each( function() {
							
							if($(this).hasClass('custom_raio')){
								
								var fb_name=$(this).attr('name');
								var val_phoen=$("input[name='"+fb_name+"']:checked").val();
								
								if (val_phoen != '' && val_phoen != undefined ) {
									$(this).removeClass("phoen_main_add_cart");
								}else{
									jQuery(".woocommerce div.product form.cart .single_add_to_cart_button").prop("disabled",true);	
								}
								
							}else if($(this).hasClass('custom_checkbox') ){
								
								if($(this).hasClass("phoen_custom_options_"+i+"")){
									var val_phoen=$("input:checkbox.phoen_custom_options_"+i+":checked").length;
									
									if (val_phoen > 0 && val_phoen != undefined ) {
										$(".phoen_custom_options_"+i+"").each(function (){
											
											$(this).removeClass("phoen_main_add_cart");
											
										});	
									}else{
										jQuery(".woocommerce div.product form.cart .single_add_to_cart_button").prop("disabled",true);	
									}
									
								}
								
							}else if($(this).hasClass('custom_field') || $(this).hasClass('custom_textarea') || $(this).hasClass('custom_file')){
								
								
								var new_main='';
								if($(this).hasClass("text_custom_"+i+"")){
									
									
									$(".text_custom_"+i+"").each(function(){
										if($(this).val() !==''){
											 new_main=$(this).val();
										}
									})
									if (new_main !=='' && new_main != undefined ) {
										$(".text_custom_"+i+"").each(function (){
											
											$(this).removeClass("phoen_main_add_cart");
											
										});	
									}else{
										jQuery(".woocommerce div.product form.cart .single_add_to_cart_button").prop("disabled",true);	
									}
									
								}
								
							} else{
								if($(this).val() === ''){
									jQuery(".woocommerce div.product form.cart .single_add_to_cart_button").prop("disabled",true);	
								}else{
									$(this).removeClass("phoen_main_add_cart");
								}
							}
							
								i++;
						});
						
						var i=0;
						var val_phoen='';
						$('.phoen_sstdcbmm').each( function() {
							
								if($(this).hasClass('custom_raio')){
									var fb_name=$(this).attr('name');
									
									var val_phoen=$("input[name='"+fb_name+"']:checked").val();
									
									if ( val_phoen === '' && val_phoen == undefined) {	
										$(this).addClass("phoen_main_add_cart");
									}
										
								}else if($(this).hasClass('custom_checkbox')){
									
									if($(this).hasClass("phoen_custom_options_"+i+"")){
										var val_phoen=$("input:checkbox.phoen_custom_options_"+i+":checked").length;
										
										if (val_phoen > 0 && val_phoen != undefined ) { }
										else{
											$(".phoen_custom_options_"+i+"").each(function (){
												
												$(this).addClass("phoen_main_add_cart");
												
											});	
										}
										
									}
										
							}else if($(this).hasClass('custom_field') || $(this).hasClass('custom_textarea') || $(this).hasClass('custom_file')){
								var new_main='';
								if($(this).hasClass("text_custom_"+i+"")){
									
									$(".text_custom_"+i+"").each(function(){
										if($(this).val() !==''){
											 new_main=$(this).val();
										}
									})
																		
									if (new_main !=='' && new_main != undefined ) {}else{
										$(".text_custom_"+i+"").each(function (){
											
											$(this).addClass("phoen_main_add_cart");
											
										});	
									}
									
								}
								
							}else{
								if($(this).val() === ''){
									
									$(this).addClass("phoen_main_add_cart");	
									
								}
								}
								i++;
						});
						
						var phoen_class_length =jQuery('.phoen_main_add_cart').length;
												
						if(phoen_class_length===0){
							
							jQuery(".woocommerce div.product form.cart .single_add_to_cart_button").prop("disabled",false);	
							
						}
										
						var option_total = 0;
						
						var product_price = $(this).find( '#product-options-total' ).data( 'product-price' );
						
						if(typeof product_price == 'undefined' )
						{
							
							var product_price = $( '#product-options-total' ).attr( 'product-price' );
							
						}
						
						product_price = parseFloat( product_price ); 
												
						var product_total_price = 0;
						
						var final_total = 0;
						
						if(variation_id !=='' && variation_id !==undefined && variation_id !== 0){
							
							$('.phoen_new_'+variation_id+' .phoen-variation-options').each( function() {
							
									var option_price = 0;
									
									var value_entered =  $(this).val();
							
									if( $(this).is('.custom_field') )
									{
										
										if( value_entered != '' )
										{
											
											option_price = $(this).attr('data-price');
											
										}
										
									}
									else if( $(this).is('.custom_textarea') )
									{
										
										if( value_entered != '' )
										{
											
											option_price = $(this).attr('data-price');
											
										}
										
									}
									else if( $(this).is('.custom_checkbox') )
									{
										
										if ( $(this).is(':checked') )
										{
											
											option_price = $(this).attr('data-price');
											
										}
										
									}
									else if( $(this).is('.custom_raio') )
									{
										
										if ( $(this).is(':checked') )
										{
											
											option_price = $(this).attr('data-price');
											
										}
										
									}
									else if( $(this).is('.custom_select') )
									{
										if( value_entered != '' )
										{
											
											option_price = $(this).find('option:selected').attr('data-price');
											
										}
										
									}
									else if( $(this).is('.custom_range') )
									{
									
										if( value_entered != '' )
										{
											if($(this).attr('data-range') === "fixed"){
												
												option_price =  $(this).attr('data-price');
												
											}else{
												
												option_price =  $(this).attr('data-price') * value_entered;
												
											}
											
										}
										
									}
									
									else if( $(this).is('.custom_quantity') )
									{
										
										if( value_entered != '' )
										{
											option_price =  $(this).attr('data-price') * value_entered;
											
										}
										
									}
									else
									{
										
										if( value_entered != '' )
										{
											
											option_price = $(this).attr('data-price');
											
										}
										
									}
									
									if(value_entered != '' && option_price != 0)
									{
										
										option_total = parseFloat( option_total ) + parseFloat( option_price );
										
									}
									
								});
								var qty_div = $('.qty');

						if ( qty_div.length){
							var qty = qty_div.val();
						}else{
							var qty = 1;
						}
						if ( option_total != 0 && qty > 0 ) {
							
							option_total = option_total * qty;
							
							option_total = option_total.toFixed(2); 
							
							option_total = parseFloat( option_total ); 
							
							//console.log( product_price );

							if ( product_price ) {

								product_total_price = product_price * qty;
								
								product_total_price = product_total_price.toFixed(2); 
								
								product_total_price = parseFloat( product_total_price ); 
								
								//alert( product_total_price );

							}
							
							//alert( option_total+'--'+product_price );
							
							final_total = option_total + product_total_price;
							
							final_total = final_total.toFixed(2); 
							
													
							
							<?php 
							
							$decimale_separator = wc_get_price_decimal_separator();
							
							?>
							var decimale_separator = '<?php echo $decimale_separator;?>';
							
							if(decimale_separator != '.'){
								
								option_total = option_total.toString();
								
								option_total = option_total.replace('.',decimale_separator);
								
								final_total = final_total.replace('.',decimale_separator);
							}
							
							
							
							//setTimeout(function(){  }, 1000);
							
							html = '';
							
							if(woocommerce_custom_options_params.show_op == 1)
							{
								
								html = html + '<dl class="product-options-price phoen_belo_head"><dt> ' + woocommerce_custom_options_params.op_show + '</dt><dd><strong><span class="amount">' + woocommerce_custom_options_params.currency_symbol+option_total + '</span></strong></dd>';
							
							}
							
							if ( final_total ) {
								
								if(woocommerce_custom_options_params.show_ft == 1)
								{
									
									html = html + '<dt>' + woocommerce_custom_options_params.ft_show + '</dt><dd><strong><span class="amount">' + woocommerce_custom_options_params.currency_symbol+final_total + '</span></strong></dd>';
								
								}

							}

							html = html + '</dl>';

							$('#product-options-total').html( html );
								
							} else {
								
								$('#product-options-total').html( '' );
							}
								
								
						}
						
					});
					
				});
				
				</script>
            <?php
            
        }
		
		add_action('admin_head','phoen_custom_admin_assets');
		
		function phoen_custom_admin_assets(){
			wp_enqueue_style('font-awesome-lib','https://maxcdn.bootstrapcdn.com/font-awesome/4.6.3/css/font-awesome.min.css');
		}
		
		add_action( 'wp_ajax_phoen_variation_data_product', 'phoen_variation_data_product_call' );

		add_action( 'wp_ajax_nopriv_phoen_variation_data_product', 'phoen_variation_data_product_call' );
		
		function phoen_variation_data_product_call(){
					
			parse_str($_POST["form"], $_POST);
			
			$variation_id= $_POST['phoe_variation_id'];
			
			for($pm=0;$pm<=count($variation_id)-1;$pm++){
			
				$product_custom_options = array();
			
				$product_custom_options_new = array();
				
				
				$product_option_position_yyw ='';
										
				if ( isset( $_POST[ 'product_option_name' ][$variation_id[$pm]] ) ) 
				{
					
					
					$option_name  = $_POST['product_option_name'][$variation_id[$pm]];
					
					$addon_11_uid  = $_POST['option_uid'][$variation_id[$pm]];
					
					$product_option_uid  = $_POST['product_option_uid'][$variation_id[$pm]];
					
					$option_des  = $_POST['product_option_des'][$variation_id[$pm]];
					
					$option_price_type  = $_POST['option_price_type'][$variation_id[$pm]];
					
					
					$phoen_new_section_style  = $_POST['phoen_new_section_style'][$variation_id[$pm]];
			
					
					update_option("phoen_new_section_style_product$variation_id[$pm]",$phoen_new_section_style);
					
					$option_qty_type  = $_POST['option_qty_type'][$variation_id[$pm]];
					
					$option_type  = $_POST['product_option_type'][$variation_id[$pm]];
											
					$product_option_inner_position  = $_POST['product_option_inner_position'][$variation_id[$pm]];
					
					$option_label_position  = $_POST['label_position'][$variation_id[$pm]];
					
					$option_desc_options  = $_POST['desc_options'][$variation_id[$pm]];
					
					$option_option_show_add_to_cart  = $_POST['option_show_add_to_cart'][$variation_id[$pm]];
					
					$option_datetime_show  = $_POST['datetime_show'][$variation_id[$pm]];
					
					$option_datetime_type  = $_POST['datetime_type'][$variation_id[$pm]];
					
					$option_required   = isset( $_POST['product_option_required'][$variation_id[$pm]] ) ? $_POST['product_option_required'][$variation_id[$pm]] : array();
					
					$option_showf   = isset( $_POST['product_option_showf'][$variation_id[$pm]] ) ? $_POST['product_option_showf'][$variation_id[$pm]] : array();
					
					$option_showaf   = isset( $_POST['product_option_showaf'][$variation_id[$pm]] ) ? $_POST['product_option_showaf'][$variation_id[$pm]] : array();

					$addon_replace_image = $_POST['replace_image'][$variation_id[$pm]];
					
					$range_min = $_POST['range_min'][$variation_id[$pm]];
					
					$range_max = $_POST['range_max'][$variation_id[$pm]];
					
					$rang_type = $_POST['rang_type'][$variation_id[$pm]];
					
					$range_step = $_POST['range_step'][$variation_id[$pm]];
					
					$product_new_price = $_POST['product_new_price'][$variation_id[$pm]];
					
					$addon_phoen_option_desc_main = $_POST['phoen_option_desc_main'][$variation_id[$pm]];
					
					$addon_product_option_default = $_POST['product_option_default'][$variation_id[$pm]];
					
					$hide_default_value = $_POST['hide_default_value'][$variation_id[$pm]];
					
					$option_show_price = $_POST['option_show_price'][$variation_id[$pm]];
					
					$addon_option_label = $_POST['product_option_label'][$variation_id[$pm]];
					
					$addon_option_price = $_POST['product_option_price'][$variation_id[$pm]];
					
					$addon_option_price_pp = $_POST['product_option_price_pp'][$variation_id[$pm]];
					
					$addon_option_max   = $_POST['product_option_max'][$variation_id[$pm]];
					
					$all_custom_use   = $_POST['all_custom_use'][$variation_id[$pm]];
					
					$all_custom_s_h   = $_POST['all_custom_s_h'][$variation_id[$pm]];
					
					$all_custom_field_dd   = $_POST['all_custom_field_dd'][$variation_id[$pm]];
					
					$all_custom_s_h_aa   = $_POST['all_custom_s_h_aa'][$variation_id[$pm]];
					
					$all_custom_con   = $_POST['all_custom_con'][$variation_id[$pm]];
					
					$all_custom_field   = $_POST['all_custom_field'][$variation_id[$pm]];
					
					$product_custom_data = array();
					
					$product_option_inner_position_m='';
					
					for($m=0; $m < count( $option_name ); $m++){
					
						$data   = array();
						
						$product_option_inner_position_m=$product_option_inner_position[$m];
						
						
						for ( $i = 0; $i < sizeof( $option_name[$m] ); $i++ ) 
						{

							if ( ! isset( $option_name[$m][ $i ] ) || ( '' == $option_name[$m][ $i ] ) ) {
								
								continue;
								
							}
							
							$addon_options 	= array();
							
							$addon_11  	= $addon_11_uid[$m][ $i ];
							
							$option_label  	= $addon_option_label[$m][ $i ];
							
							$replace_image  	= $addon_replace_image[$m][ $i ];
							
							$phoen_option_desc_main  	= $addon_phoen_option_desc_main[$m][ $i ];
														
							$option_price  	= $addon_option_price[$m][ $i ];
							
							$option_price_pp  	= $addon_option_price_pp[$m][ $i ];
							
							$option_max		= $addon_option_max[$m][ $i ];
								
								
								
								$image='';
							for ( $ii = 0; $ii < sizeof( $option_label ); $ii++ ) {
								
								$label 	= sanitize_text_field( stripslashes( $option_label[ $ii ] ) );
								
								$option_uid_12 	= sanitize_text_field( stripslashes( $addon_11[ $ii ] ) );
								
								$image 	= sanitize_text_field( stripslashes( $replace_image[ $ii ] ) );
								
								$desc_main 	= sanitize_text_field( stripslashes( $phoen_option_desc_main[ $ii ] ) );
								
								$price 	= wc_format_decimal( sanitize_text_field( stripslashes( ( $option_price[ $ii ] != '' ) ? $option_price[ $ii ] : 0 ) ) );
								
								$price_pp 	=  sanitize_text_field( stripslashes( $option_price_pp[ $ii ] ) );
								
								$max	= sanitize_text_field( stripslashes( $option_max[ $ii ] ) );
								
								if($label != '')
								{
									$addon_options[] = array(
										'label' => $label,
										'random' => $option_uid_12,
										'replace_image' => $image,
										'descr' => $desc_main,
										'price' => $price,
										'price_pp' => $price_pp,
										'max'	=> $max
									);
								}
								
							}
							
							$addon_options_con 	= array();
							
							$all_custom_field_d  	= $all_custom_field_dd[$m][ $i ];
							
							$all_custom_co 	= $all_custom_con[$m][ $i ];
							
							$all_custom_fiel		= $all_custom_field[$m][ $i ];

							
							
							for ( $iii = 0; $iii < sizeof( $all_custom_field_d ); $iii++ ) {
								
								$custom_field_dd 	= sanitize_text_field( stripslashes( $all_custom_field_d[ $iii ] ) );
								
								$custom_con 	=  sanitize_text_field( stripslashes( $all_custom_co[ $iii ] ) );
								
								if( $custom_con == 'isempty' || $custom_con == 'isnotempty' )
								{
									
									$custom_field	= 'blank';
									
								}
								else
								{
									
									$custom_field	= sanitize_text_field( stripslashes( $all_custom_fiel[ $iii ] ) );
									
								}

								if($custom_field_dd != '')
								{
									
									$addon_options_con[] = array(
										'custom_field_dd' => sanitize_title( $custom_field_dd ),
										'custom_con' => $custom_con,
										'custom_field'	=> sanitize_title( $custom_field )
									);
									
								}
								
							}
				
						
						
							$data[]=array(
									'name'=>sanitize_text_field( stripslashes( $option_name[$m][ $i ] ) ),
									'phoen_uid'=>sanitize_text_field( stripslashes( $product_option_uid[$m][ $i ] ) ),
									'des'=>sanitize_text_field( stripslashes( $option_des[$m][ $i ] ) ),
									'all_custom_use'=>sanitize_text_field( stripslashes( $all_custom_use[$m][ $i ] ) ),
									'all_custom_s_h'=> sanitize_text_field( stripslashes( $all_custom_s_h[$m][ $i ] ) ),
									'all_custom_s_h_aa'=>sanitize_text_field( stripslashes( $all_custom_s_h_aa[$m][ $i ] ) ),
									'price_type'=>sanitize_text_field( stripslashes( $option_price_type[$m][ $i ] ) ),
									'qty_type'=>sanitize_text_field( stripslashes( $option_qty_type[$m][ $i ] ) ),
									'type'=> sanitize_text_field( stripslashes( $option_type[$m][ $i ] ) ),
									'label_position'=>sanitize_text_field( stripslashes( $option_label_position[$m][ $i ] ) ),
									'desc_options'=>sanitize_text_field( stripslashes( $option_desc_options[$m][ $i ] ) ),
									'option_show_add_to_cart'=>sanitize_text_field( stripslashes( $option_option_show_add_to_cart[$m][ $i ] ) ),
									'datetime_show'=>sanitize_text_field( stripslashes( $option_datetime_show[$m][ $i ] ) ),
									'datetime_type'=>sanitize_text_field( stripslashes( $option_datetime_type[$m][ $i ] ) ),
									'product_option_default'=> sanitize_text_field( stripslashes( $addon_product_option_default[$m][ $i ] ) ),
									'hide_default_value'=> sanitize_text_field( stripslashes( $hide_default_value[$m][ $i ] ) ),
									'option_show_price'=>sanitize_text_field( stripslashes( $option_show_price[$m][ $i ] ) ),
									'range_min'=> sanitize_text_field( stripslashes( $range_min[$m][ $i ] ) ),
									'range_step'=>sanitize_text_field( stripslashes( $range_step[$m][ $i ] ) ),
									'product_new_price'=>sanitize_text_field( stripslashes( $product_new_price[$m][ $i ] ) ),
									'range_max'=> sanitize_text_field( stripslashes( $range_max[$m][ $i ] ) ),
									'rang_type'=> sanitize_text_field( stripslashes( $rang_type[$m][ $i ] ) ),
									'position'=>absint( $option_position[$m][ $i ] ),
									'options'=> $addon_options,
									'options_con'=> $addon_options_con,
									'required'=> isset( $option_required[$m][ $i ] ) ? 1 : 0,
									'option_showf'=> isset( $option_showf[$m][ $i ] ) ? 1 : 0,
									'option_showaf'=>isset( $option_showaf[$m][ $i ] ) ? 1 : 0,
								);
							
					
		
					
						
						}
					
					$product_custom_data=array();
					
					if(isset($product_option_inner_position_m) && is_array($product_option_inner_position_m) && isset($data) && is_array($data)){
						
						foreach($product_option_inner_position_m as $hhye => $knumb){
								
								foreach($data as $key => $val){
									
									if($key==$hhye){
										
										$product_custom_data[$hhye]=$val;
									
										
									}
									
								}
								
						}
						
					}

							$product_custom_options[$m] = $product_custom_data;
					}
					
			
					$product_option_position_yyw  = $_POST['product_option_position'][$variation_id[$pm]];
					
					
					
						
					
					if(isset($product_custom_options) && is_array($product_custom_options) && isset($product_option_position_yyw) && is_array($product_option_position_yyw)){
						
						foreach($product_option_position_yyw as $ooi => $jju){
								
							foreach($product_custom_options as $key => $val){
									
										
									
									if($key==$ooi){
										
										$product_custom_options_new[$ooi]=$val;
									
										
									}
								
							}
							
						}
						
					}
			
						
							
				}
				
				update_post_meta( $variation_id[$pm], '_variation_custom_options', $product_custom_options_new );
			}
				
			
		}
		
		
	}
	else 
	{
		
		add_action('admin_notices', 'custom_options_admin_notice');

		function custom_options_admin_notice() {
			
			global $current_user ;
			
				$user_id = $current_user->ID;
				
			/* Check that the user hasn't already clicked to ignore the message */
				
			if ( ! get_user_meta($user_id, 'custom_options_ignore_notice') ) {
				
				echo '<div class="error"><p>'; 
				
				printf(__('Woocommerce custom options could not detect an active Woocommerce plugin. Make sure you have activated it. | <a href="%1$s">Hide Notice</a>'), '?custom_options_nag_ignore=0');
				
				echo "</p></div>";
			}
		}

		add_action('admin_init', 'custom_options_nag_ignore');

		function custom_options_nag_ignore() {
			
			global $current_user;
			
				$user_id = $current_user->ID;
				
				/* If user clicks to ignore the notice, add that to their user meta */
				
				if ( isset($_GET['custom_options_nag_ignore']) && '0' == $_GET['custom_options_nag_ignore'] ) {
					
						 add_user_meta($user_id, 'custom_options_ignore_notice', 'true', true);
						 
				}
		}
		
	}
?>
