<?php
/**
 * Plugin Name: Shipping Zones by Drawing for WooCommerce
 * Plugin URI: https://arosoft.se/product/shipping-zones-drawing-premium/
 * Description: Limit WooCommerce shipping methods by a drawn shipping zone or by a transportation radius.
 * Version: 2.4.3.1
 * Author: Arosoft.se
 * Author URI: https://arosoft.se
 * Developer: Arosoft.se
 * Developer URI: https://arosoft.se
 * Text Domain: szbd
 * Domain Path: /languages
 * WC requires at least: 4.0
 * WC tested up to: 4.6
 * Copyright: Arosoft.se 2020
 * License: GPL v2 or later
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
if (!defined('ABSPATH')) {
  exit;
}

define('SZBD_VERSION', '2.4.3.1');
define('SZBD_PLUGINDIRURL', plugin_dir_url(__FILE__));
define('SZBD_PLUGINDIRPATH', plugin_dir_path(__FILE__));

// Register hook for activation
register_activation_hook(__FILE__, array(
  'SZBD',
  'activate'
));

// Register hook for uninstallation
register_uninstall_hook(__FILE__, array(
  'SZBD',
  'uninstall'
));

if (!class_exists('SZBD')) {
  /**
   * Main Class SZBD
   *
   * @since 1.0.0
   */

  class SZBD {
    const TEXT_DOMAIN = 'szbd';
    const POST_TITLE = 'szbdzones';
    protected static $_instance = null;
    public $notices;

    // to be run on plugin activation
    static public function activate() {
      $admin = get_role('administrator');
      flush_rewrite_rules();
      $admin_capabilities = array(
        'delete_szbdzones',
        'delete_others_szbdzones',
        'delete_private_szbdzones',
        'delete_published_szbdzones',
        'edit_szbdzones',
        'edit_others_szbdzones',
        'edit_private_szbdzones',
        'edit_published_szbdzones',
        'publish_szbdzones',
        'read_private_szbdzones'
      );
      foreach ($admin_capabilities as $capability) {
        $admin->add_cap($capability);
      }
    }

    // to be run on plugin uninstallation
    public static function uninstall() {

      unregister_post_type('szbdzones');
      flush_rewrite_rules();
    }

    public static function instance() {
      NULL === self::$_instance and self::$_instance = new self;
      return self::$_instance;
    }

    // The Constructor
    public function __construct() {



      add_filter('plugin_action_links_' . plugin_basename(__FILE__) , array(
        $this,
        'add_action_links'
      ));
      add_action('init', array(
        $this,
        'load_text_domain'
      ));
      add_action('admin_init', array(
        $this,
        'check_environment'
      ));
      add_action('plugins_loaded', array(
        $this,
        'init'
      ) , 10);
      add_action('admin_notices', array(
        $this,
        'admin_notices'
      ) , 15);
      add_action('wp_enqueue_scripts', array(
        $this,
        'enqueue_scripts'
      ) , 1000);

      add_action('wp', array(
        $this,
        'init_shortcode'
      ));
      add_filter('manage_edit-szbdzones_columns', array(
        $this,
        'posts_columns_id'
      ) , 2);

      add_action('manage_posts_custom_column', array(
        $this,
        'posts_custom_id_columns'
      ) , 5, 2);

      add_action('woocommerce_review_order_before_payment',array($this, 'insert_to_checkout') );

    }

    public function enqueue_scripts() {

      if (wc_post_content_has_shortcode('szbd') || get_option('szbd_force_shortcode', 'no') == 'yes') {
        $deps = array(
          'jquery',
          'underscore'
        );
        if (get_option('szbd_deactivate_google', 'no') == 'no') {
          $google_api_key = get_option('szbd_google_api_key', '');
          wp_register_script('szbd-script', 'https://maps.googleapis.com/maps/api/js?key=' . $google_api_key . '&libraries=geometry,places,drawing', array() , SZBD_VERSION, true);

          if (wp_script_is('szbd-google-autocomplete-2', 'enqueued')) {

            $deps[] = 'szbd-google-autocomplete-2';
          }
          else {
            wp_enqueue_script('szbd-script');
            $deps[] = 'szbd-script';
          }

        }
        wp_register_script('szbd-script-short', SZBD_PLUGINDIRURL . '/assets/szbd-shortcode.js', $deps, SZBD_VERSION, true);

        wp_enqueue_script('szbd-script-short');
        wp_enqueue_style('szbd-style-shortcode', SZBD_PLUGINDIRURL . '/assets/style-shortcode.css', array() , SZBD_VERSION);
      }
    }
    public function init() {
      // check if environment is ok
      if (self::get_environment_warning()) {
        return;
      }
      $this->includes();
    }

    // Includes plugin files
    public function includes() {
      if (is_admin()) {
        require_once (SZBD_PLUGINDIRPATH . 'classes/class-szbd-settings.php');

        require_once (SZBD_PLUGINDIRPATH . 'classes/class-szbd-admin.php');
        $this->admin = new SZBD_Admin();
      }
      require_once (SZBD_PLUGINDIRPATH . 'classes/class-szbd-shippingmethod.php');
      require_once (SZBD_PLUGINDIRPATH . 'classes/class-szbd-the-post.php');
    }
    public function init_shortcode() {

      if (!is_admin() && !is_ajax() && !self::get_environment_warning()) {
        require_once (SZBD_PLUGINDIRPATH . 'classes/class-szbd-shortcode.php');
        $this->shortcode = SZBD_Shortcode::instance();

      }
    }
    // For use in future versions. Loads text domain files
    public function load_text_domain() {
      load_plugin_textdomain('szbd', false, dirname(plugin_basename(__FILE__)) . '/languages/');
    }




    public function insert_to_checkout() {
       if (class_exists('Food_Online_Del') && get_option('fdoe_enable_delivery_switcher', 'no') !== 'no' && (get_option('fdoe_skip_address_validation', 'no') !== 'yes' &&  'skip' !== WC()->session->get('fdoe_bypass_validation',false))) {
      return;
    }
    if( 'local_pickup' == WC()->session->get('fdoe_shipping') || 'eathere' == WC()->session->get('fdoe_shipping') ){
      return;
    }

    if ( get_option('fdoe_pick_delivery_location','') == 'no') {

      return;
    }
     if (!is_checkout() || WC()
      ->cart
      ->needs_shipping() === false) {
      return;
    }

      $option = get_option('szbd_precise_address','no') ;
      if($option != 'at_fail'){
        return;
      }else if($option == 'at_fail'){
        $class ='szbd-hide';
      }


    echo '<div id="szbd_checkout_field" class="shop_table '.$class.'"><h3>' . __('Please Precise Your Location','szbd') . '</h3>';

    woocommerce_form_field( 'szbd-picked', array(
        'type'          => 'text',
        'class'         => array('szbd-hidden'),
        'label'         => __('Precise Address?','szbd'),

        ));

    ?>

<div id="szbd-pick-content">
	<div class="szbd-checkout-map">
		<div id="szbd_map"> </div></div></div></div>

 <?php


         }

    // Add setting links to Plugins page
    public function add_action_links($links) {
      if (plugin_basename(__FILE__) == "shipping-zones-by-drawing-for-woocommerce/shipping-zones-by-drawing.php") {
        $links_add = array(
          '<a href="' . admin_url('admin.php?page=wc-settings&tab=szbdtab') . '">Settings</a>',
          '<a href="https://arosoft.se/product/shipping-zones-drawing-premium/">Go Premium</a>'
        );
      }
      else {
        $links_add = array(
          '<a href="' . admin_url('admin.php?page=wc-settings&tab=szbdtab') . '">Settings</a>'
        );
      }
      return array_merge($links, $links_add);
    }

    // Checks if WooCommerce etc. is active and if not returns error message
    static function get_environment_warning() {
      include_once (ABSPATH . 'wp-admin/includes/plugin.php');
      if (!defined('WC_VERSION')) {
        return __('Shipping Zones by Drawing requires WooCommerce to be activated to work.', 'szbd');
        die();
      }
      //if this is Premium
      /*
      else if (is_plugin_active('shipping-zones-by-drawing-for-woocommerce/shipping-zones-by-drawing.php'))
      {
      return __('Shipping Zones by Drawing Premium can not be activated when the free version is active.', 'szbd');
      die();
      }*/
      // If this is free version
      else if (is_plugin_active('shipping-zones-by-drawing-premium/shipping-zones-by-drawing.php')) {
        return __('Shipping Zones by Drawing can not be activated when the premuim version is active.', 'szbd');
        die();
      }
      return false;
    }

    // Checks if environment is ok
    public function check_environment() {
      $environment_warning = self::get_environment_warning();
      if ($environment_warning && is_plugin_active(plugin_basename(__FILE__))) {
        $this->add_admin_notice('bad_environment', 'error', $environment_warning);
        deactivate_plugins(plugin_basename(__FILE__));
      }
    }

    // Adds notice if environmet is not ok
    public function add_admin_notice($slug, $class, $message) {
      $this->notices[$slug] = array(
        'class' => $class,
        'message' => $message
      );
    }

    public function admin_notices() {
      foreach ((array)$this->notices as $notice_key => $notice) {
        echo "<div class='" . esc_attr($notice['class']) . "'><p>";
        echo wp_kses($notice['message'], array(
          'a' => array(
            'href' => array()
          )
        ));
        echo '</p></div>';
      }
      unset($notice_key);
    }

    function posts_columns_id($defaults) {
      $defaults['szbd_post_id'] = __('ID');
      return $defaults;
    }
    function posts_custom_id_columns($column_name, $id) {
      if ($column_name === 'szbd_post_id') {
        echo $id;
      }
    }

    static function get_store_address() {

      $store_address = get_option('woocommerce_store_address', '');
      $store_address_2 = get_option('woocommerce_store_address_2', '');
      $store_city = get_option('woocommerce_store_city', '');
      $store_postcode = get_option('woocommerce_store_postcode', '');
      $store_raw_country = get_option('woocommerce_default_country', '');
      $split_country = explode(":", $store_raw_country);
      // Country and state
      $store_country = $split_country[0];
      // Convert country code to full name if available
      if (isset(WC()
        ->countries
        ->countries[$store_country])) {
        $store_country = WC()
          ->countries
          ->countries[$store_country];
      }
      $store_state = isset($split_country[1]) ? $split_country[1] : '';
      $store_loc = array(
        'store_address' => $store_address,
        'store_address_2' => $store_address_2,
        'store_postcode' => $store_postcode,
        'store_city' => $store_city,

        'store_state' => $store_state,
        'store_country' => $store_country,

      );

      return $store_loc;
    }

  }
}
$GLOBALS['szbd_item'] = SZBD::instance();
add_action( 'woocommerce_checkout_update_order_meta', 'szbd_checkout_field_update_order_meta' );

function szbd_checkout_field_update_order_meta( $order_id ) {
       if ( isset( $_POST['szbd-picked'] ) && !empty( $_POST['szbd-picked'] && $_POST['szbd-picked'] != '' ) ) {

        update_post_meta( $order_id, 'szbd_picked_delivery_location', sanitize_text_field( $_POST['szbd-picked'] ) );
    }
}


add_action( 'woocommerce_admin_order_data_after_billing_address', 'szbd_show_checkout_field_admin_order_meta', 10, 1 );

function szbd_show_checkout_field_admin_order_meta($order){
  $meta = get_post_meta( $order->get_id(), 'szbd_picked_delivery_location', true );
   if(is_string($meta) && $meta != '' && !empty($meta) && $meta !== false ){

    echo '<p><strong>'.__('Picked Delivery Location','szbd').':</strong> ' . $meta . '</p>';
  }
}

add_filter( 'woocommerce_email_order_meta', 'szbd_add_picked_location_to_emails', 20, 4 );

function szbd_add_picked_location_to_emails( $order, $sent_to_admin, $plain_text, $email ) {
   $meta = get_post_meta( $order->get_id(), 'szbd_picked_delivery_location', true );
   if(is_string($meta) && $meta != '' && !empty($meta) && $meta !== false ){
 $location =json_decode($meta);
 if($location !== null && isset($location->lat)){

	if ( $email->id == 'customer_processing_order'  ) {

    $lat =$location->lat;
    $long =$location->lng;
     echo '<p><strong>'.__('Picked Delivery Location','szbd').':</strong> ';
	echo '<a href="https://www.google.com/maps/search/?api=1&query='.$lat.','.$long.'" ><br>'.__('Open delivery location with Google Maps','szbd').'</a></p>';
	}
	if ( $email->id == 'customer_completed_order' ){

     $lat =$location->lat;
    $long =$location->lng;
     echo '<p><strong>'.__('Picked Delivery Location','szbd').':</strong>';
	echo '<a href="https://www.google.com/maps/search/?api=1&query='.$lat.','.$long.'" ><br>'.__('Open delivery location with Google Maps','szbd').'</a></p>';
	}
	if ( $email->id == 'new_order' ) {


    $lat =$location-> lat;
    $long =$location->lng;
     echo '<p><strong>'.__('Picked Delivery Location','szbd').':</strong>';
	echo '<a href="https://www.google.com/maps/search/?api=1&query='.$lat.','.$long.'" ><br>'.__('Open delivery location with Google Maps','szbd').'</a></p>';
	}
}
}
}
add_action( 'woocommerce_thankyou','szbd_add_picked_location_to_thankyou_page', 99,1 );

function szbd_add_picked_location_to_thankyou_page($order_id){
  $meta = get_post_meta( $order_id, 'szbd_picked_delivery_location', true );
  if(is_string($meta) && $meta != '' && !empty($meta) && $meta !== false ){

   $location =json_decode($meta);
     if($location !== null && isset($location->lat)){
    $lat =$location->lat;
    $long =$location->lng;
     echo '<p><strong>'.__('Picked Delivery Location','szbd').':</strong> ';
	echo '<a href="https://www.google.com/maps/search/?api=1&query='.$lat.','.$long.'" ><br>'.__('Open delivery location with Google Maps','szbd').'</a></p>';
  }
  }
}