jQuery(document).ready(function($) {
	if ($('#szbd_store_address_mode').find('option:selected').attr("value") == 'pick_store_address') {
		init_map();
	} else {
		jQuery('#szbd-pick-content').hide();
		jQuery('#szbd_settings_test-description').hide();
		jQuery('#szbd_settings_test-description').prev('h2').hide();
	}
		$('#szbd_exclude_shipping_methods').attr('disabled', 'disabled');
	jQuery('.woocommerce_page_wc-settings').find('.in_premium').parent('label').after('<span class="premium_link" ><a  target="_blank" class="premium_link_ref" href="https://arosoft.se/product/shipping-zones-drawing-premium/">Premium</a></span>');

	 $('#szbd_precise_address').children('option').each(function() {
        if ( $(this).val() === 'always_' ) {
            $(this).attr('disabled', true);
        }
    });
	$('#szbd_store_address_mode').change(function() {
		if ($(this).find('option:selected').attr("value") == 'pick_store_address') {
			jQuery('#szbd_settings_test-description').slideDown();
			jQuery('#szbd_settings_test-description').prev('h2').slideDown();
			jQuery('#szbd-pick-content').slideDown(function() {
				if (jQuery('#szbd_map').children().length) {
				} else {
					init_map();
				}
			});
		} else {
			jQuery('#szbd-pick-content').slideUp();
			jQuery('#szbd_settings_test-description').slideUp();
			jQuery('#szbd_settings_test-description').prev('h2').slideUp();
		}
	});
	var map;
	var marker;

	function init_map() {
		test_store_address();
		show_store_map();
		szbd_save_main_options_ajax();
	}
	// Helping methods
	function findCommonElements(arr1, arr2) {
		return arr1.some(item => arr2.includes(item));
	}

	function show_store_map() {
		initMap(szbd_settings.store_location);
		grabAddress();
	}

	function grabAddress() {
		var input = document.getElementById('szbdzones_address');
		var searchBox = new google.maps.places.SearchBox(input);
		map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);
		map.addListener('bounds_changed', function() {
			searchBox.setBounds(map.getBounds());
		});
		var markers = [];
		searchBox.addListener('places_changed', function() {
			var places = searchBox.getPlaces();
			if (places.length == 0) {
				return;
			}
			markers.forEach(function(marker) {
				marker.setMap(null);
			});
			markers = [];
			var bounds = new google.maps.LatLngBounds();
			places.forEach(function(place) {
				if (!place.geometry) {
					return;
				}
				var icon = {
					url: place.icon,
					size: new google.maps.Size(71, 71),
					origin: new google.maps.Point(0, 0),
					anchor: new google.maps.Point(17, 34),
					scaledSize: new google.maps.Size(25, 25)
				};
				markers.push(new google.maps.Marker({
					map: map,
					icon: icon,
					title: place.name,
					position: place.geometry.location
				}));
				if (place.geometry.viewport) {
					bounds.union(place.geometry.viewport);
				} else {
					bounds.extend(place.geometry.location);
				}
			});
			map.fitBounds(bounds);
		});
	}

	function initMap(uluru) {
		var mapOptions;
		var markerOptions;
		if (typeof uluru == 'undefined' || uluru == null) {
			mapOptions = {
				zoom: 1,
				center: {
					lat: 0,
					lng: 0
				},
			};
			map = new google.maps.Map(
				document.getElementById('szbd_map'), mapOptions);
		} else {
			mapOptions = {
				zoom: 18,
				center: uluru
			};
			map = new google.maps.Map(
				document.getElementById('szbd_map'), mapOptions);
			markerOptions = {
				position: uluru,
				map: map,
				draggable: true,
			};
			marker = new google.maps.Marker(markerOptions);
		}
		jQuery('#szbd_map').height(400);
		google.maps.event.addListener(map, 'click', function(event) {
			placeMarker(event.latLng);
		});
	}

	function placeMarker(location) {
		if (marker) {
			marker.setPosition(location);
		} else {
			marker = new google.maps.Marker({
				position: location,
				map: map,
				draggable: true,
			});
		}
	}

	function test_store_address() {
		$('#szbd-test-address').off('click').on('click', function(event, ui) {
			jQuery('.szbd-admin-map').block({
				message: null,
				overlayCSS: {
					background: '#fff',
					opacity: 0.6
				}
			});
			var data = {
				'action': 'test_store_address',
			};
			$.post(
				szbd_settings.ajax_url,
				data,
				function(response) {
					var store_address = response.store_address;
					var geocode_storeaddress = new google.maps.Geocoder();
					geocode_storeaddress.geocode({
							'address': store_address.store_address + ',' + store_address.store_postcode + ',' + store_address.store_city + ',' + store_address.store_state + ',' + store_address.store_country
						},
						function(results, status) {
							var ok_types = ["street_address", "subpremise", "premise", "establishment", "route"];
							if (status === 'OK' && findCommonElements(results[0].types, ok_types)) {
								initMap(results[0].geometry.location);
								//szbd_save_main_options_ajax(results[0].geometry.location);
								jQuery('#szbd-test-result').html('<div class=""> <br><span class="szbd-heading">STORE ADDRESS OK!</span> <br>' + (results[0].formatted_address) + '</div>');
							} else {
								jQuery('#szbd-test-result').html('<div class=""> <br><span class="szbd-heading-fail">STORE ADDRESS NOT OK!</span> <br>' + JSON.stringify(results) + '</div>');
							}
						});
				}).always(function() {
				jQuery('.szbd-admin-map').unblock();
			});
		});
	}

	function szbd_save_main_options_ajax() {
		if ($('#szbd_store_location').length) {
			$('.button-primary.woocommerce-save-button[type=submit]').off("click").on("click", function() {
				var store_location = marker.getPosition();
				if (store_location) {
					document.getElementById('szbd_store_location').value = JSON.stringify(store_location);
				} else {
					return;
				}
			});
		} else {
			return;
		}
	}
});
