<?php
/**
 * The main plugin file for WooCommerce Restaurant Ordering.
 *
 * This file is included during the WordPress bootstrap process if the plugin is active.
 *
 * @package   Barn2\woocommerce-restaurant-ordering
 * @author    Barn2 Plugins <support@barn2.co.uk>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 *
 * @wordpress-plugin
 * Plugin Name:     WooCommerce Restaurant Ordering
 * Plugin URI:      https://barn2.co.uk/wordpress-plugins/woocommerce-restaurant-ordering/
 * Description:     A restaurant ordering plugin for WooCommerce.
 * Version:         1.2.1
 * Author:          Barn2 Plugins
 * Author URI:      https://barn2.co.uk
 * Text Domain:     woocommerce-restaurant-ordering
 * Domain Path:     /languages
 *
 * WC requires at least: 3.7
 * WC tested up to: 4.5.1
 *
 * Copyright:       Barn2 Media Ltd
 * License:         GNU General Public License v3.0
 * License URI:     http://www.gnu.org/licenses/gpl-3.0.html
 */
namespace Barn2\Plugin\WC_Restaurant_Ordering;

// Prevent direct file access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

const PLUGIN_FILE    = __FILE__;
const PLUGIN_VERSION = '1.2.1';

// Include autoloader.
require_once __DIR__ . '/vendor/autoload.php';

/**
 * Helper function to access the shared plugin instance.
 *
 * @return Plugin The plugin instance.
 */
function wro() {
    return Plugin_Factory::create( PLUGIN_FILE, PLUGIN_VERSION );
}

// Load the plugin.
wro()->register();
