<?php
namespace Barn2\Plugin\WC_Restaurant_Ordering;

/**
 * Utility functions.
 *
 * @package   Barn2\woocommerce-restaurant-ordering
 * @author    Barn2 Plugins <info@barn2.co.uk>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
class Util {

    public static function bool_to_checkbox_setting( $bool ) {
        return (bool) $bool ? 'yes' : 'no';
    }

    public static function get_checkbox_option( $option, $default = false ) {
        $value = get_option( $option, $default );
        return in_array( $value, [ 'yes', true ], true ) ? true : false;
    }

    public static function get_image_size_array( $image_size ) {
        if ( is_string( $image_size ) ) {
            //todo: Work out size array from size string (e.g. 'thumbnail')
        } else {
            // Get first 2 array elements, in case more were passed.
            $image_size = array_slice( (array) $image_size, 0, 2 );
        }

        // Sanitize and re-key array.
        $image_size = array_values( array_map( 'absint', $image_size ) );

        // Convert single size array to width x height.
        if ( 1 === count( $image_size ) ) {
            $image_size = [ $image_size[0], $image_size[0] ];
        }

        return $image_size;
    }

    public static function get_quantity_in_cart( $product_id ) {
        $quantity = 0;

        foreach ( WC()->cart->get_cart() as $cart_item ) {
            if ( $product_id === $cart_item['product_id'] ) {
                $quantity = $cart_item['quantity'];
                break;
            }
        }

        return $quantity;
    }

    public static function get_wc_notices( $notice_type ) {
        $notices = wc_get_notices( $notice_type );
        wc_clear_notices();

        // WC > 3.8 uses nested arrays for each notice.
        if ( ! empty( $notices ) && isset( $notices[0]['notice'] ) ) {
            $notices = wp_list_pluck( $notices, 'notice' );
        }

        return array_filter( $notices );
    }

}
