<?php
namespace Barn2\Plugin\WC_Restaurant_Ordering\Rest;

use Barn2\WRO_Lib\Registerable,
    Barn2\WRO_Lib\Service,
    Barn2\WRO_Lib\Rest\Rest_Server,
    Barn2\WRO_Lib\Rest\Base_Server,
    Barn2\WRO_Lib\Rest\Route;

/**
 * Main controller which registers the REST routes for the plugin.
 *
 * @package   Barn2\woocommerce-restaurant-ordering
 * @author    Barn2 Plugins <support@barn2.co.uk>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
class Rest_Controller extends Base_Server implements Registerable, Service, Rest_Server {

    const NAMESPACE = 'wc-restaurant-ordering/v1';

    /**
     * @var Route[] The list of REST route objects handled by this server.
     */
    private $routes = [];

    public function __construct() {
        $this->routes = [
            new Routes\Cart_Route( self::NAMESPACE ),
            new Routes\Order_Type_Route( self::NAMESPACE ),
            new Routes\Product_Modal_Route( self::NAMESPACE )
        ];
    }

    public function register() {
        parent::register();
        add_filter( 'nonce_user_logged_out', array( $this, 'nonce_user_logged_out' ), 50, 2 );
    }

    public function get_namespace() {
        return self::NAMESPACE;
    }

    public function get_routes() {
        return $this->routes;
    }

    /**
     * Prevent WooCommerce overriding the user ID for logged out users as this breaks our nonce validation.
     *
     * @param int $uid The user ID
     * @param string $action The nonce action
     * @return int The user ID when logged out
     */
    public function nonce_user_logged_out( $uid, $action ) {
        if ( 'wp_rest' === $action && ! is_user_logged_in() ) {
            return 0;
        }
        return $uid;
    }

}
