<?php
namespace Barn2\Plugin\WC_Restaurant_Ordering;

use Barn2\WRO_Lib\Registerable,
    Barn2\WRO_Lib\Service,
    Barn2\WRO_Lib\Conditional,
    Barn2\WRO_Lib\Rest\Rest_Server,
    Barn2\WRO_Lib\Util;

/**
 *
 * @package   Barn2\woocommerce-restaurant-ordering
 * @author    Barn2 Plugins <info@barn2.co.uk>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
class Frontend_Scripts implements Registerable, Service, Conditional {

    private $root_url;
    private $plugin_version;
    private $rest_server;
    private $scripts_loaded = false;

    public function __construct( $root_url, $plugin_version, Rest_Server $rest_server ) {
        $this->root_url       = trailingslashit( $root_url );
        $this->plugin_version = $plugin_version;
        $this->rest_server    = $rest_server;
    }

    public function is_required() {
        return Util::is_front_end();
    }

    public function register() {
        add_action( 'wp_enqueue_scripts', [ $this, 'register_scripts' ] );
    }

    public function register_scripts() {
        $assets_url = $this->root_url . 'assets/';

        // Styles
        wp_register_style( 'wc-restaurant-menu', $assets_url . 'css/front-end.css', [], $this->plugin_version );

        // Scripts
        wp_register_script( 'wc-backbone-modal', WC()->plugin_url() . '/assets/js/admin/backbone-modal.min.js', [ 'underscore', 'backbone', 'wp-util' ], WC_VERSION );
        wp_register_script( 'accounting', WC()->plugin_url() . '/assets/js/accounting/accounting.min.js', [ 'jquery' ], '0.4.2', true );
        wp_register_script( 'wc-restaurant-menu', $assets_url . 'js/restaurant-menu.js', [ 'wc-backbone-modal', 'accounting', 'wc-add-to-cart-variation' ], $this->plugin_version, true );

        $script_params = [
            'rest_nonce'            => wp_create_nonce( 'wp_rest' ),
            'rest_url'              => esc_url_raw( rest_url() ),
            'rest_endpoints'        => $this->rest_server->get_endpoints(),
            'show_cart_notice'      => apply_filters( 'wc_restaurant_ordering_show_cart_notice', true ),
            'refresh_cart'          => apply_filters( 'wc_restaurant_ordering_refresh_cart_fragments', true ),
            'price_currency_format' => str_replace( [ '%1$s', '%2$s' ], [ '%s', '%v' ], \get_woocommerce_price_format() ),
            'price_currency_symbol' => get_woocommerce_currency_symbol(),
            'price_num_decimals'    => wc_get_price_decimals(),
            'price_decimal_sep'     => wc_get_price_decimal_separator(),
            'price_thousand_sep'    => wc_get_price_thousand_separator()
        ];

        if ( apply_filters( 'woocommerce_price_trim_zeros', false ) ) {
            $script_params['price_num_decimals'] = 0;
        }

        wp_localize_script( 'wc-restaurant-menu', 'wc_restaurant_ordering_params', apply_filters( 'wc_restaurant_ordering_script_params', $script_params ) );
    }

    public function load_scripts() {
        if ( $this->scripts_loaded ) {
            return;
        }

        if ( apply_filters( 'wc_restaurant_ordering_load_frontend_scripts', true ) ) {
            wp_enqueue_style( 'wc-restaurant-menu' );
            wp_enqueue_script( 'wc-restaurant-menu' );

            if ( Util::is_product_addons_active() ) {
                // Load the Product Addons scripts. First, we double-check the function to register the scripts exists.
                if ( isset( $GLOBALS['Product_Addon_Display'] ) && method_exists( $GLOBALS['Product_Addon_Display'], 'addon_scripts' ) ) {

                    // Product Addons has a dependency on jquery tipTip which isn't passed to the deps array for the addons script, so we need to load it.
                    if ( ! wp_script_is( 'jquery-tiptip', 'registered' ) ) {
                        wp_register_script( 'jquery-tiptip', WC()->plugin_url() . '/assets/js/jquery-tiptip/jquery.tipTip.min.js', [ 'jquery' ], WC_VERSION, true );
                    }
                    wp_enqueue_script( 'jquery-tiptip' );

                    $GLOBALS['Product_Addon_Display']->addon_scripts();
                }
            }

            do_action( 'wc_restaurant_ordering_load_scripts' );
        }

        add_action( 'wp_footer', [ $this, 'load_js_templates' ] );
        $this->scripts_loaded = true;
    }

    public function load_js_templates() {
        $template_loader = Template_Loader_Factory::create();

        $template_loader->load_template(
            'modal/template.php', [
            'modal' => $template_loader->get_template(
                'modal/modal.php', [
                'content' => $template_loader->get_template(
                    'modal/content.php', [
                    'buy_button' => $template_loader->get_template( 'modal/buy-button.php' )
                ] )
            ] )
        ] );

        $template_loader->load_template(
            'cart-notice/template.php', [
            'cart_notice' => $template_loader->get_template( 'cart-notice/cart-notice.php' )
        ] );
    }

}
