'use strict';

(function($) {
  $(document).ready(function($) {
    woopt_show_action();
    woopt_show_conditional();
    woopt_show_apply();
    woopt_time_picker();
    woopt_build_value();
  });

  $(document).on('change', '.woopt_action_selector', function() {
    var $current_action = $(this).closest('.woopt_action_td');
    woopt_show_action($current_action);
    woopt_build_value();
  });

  $(document).on('change', '.woopt_weekday', function() {
    woopt_build_value();
  });

  $(document).on('change', '.woopt_weekno', function() {
    woopt_build_value();
  });

  $(document).on('change', '.woopt_conditional', function() {
    var $current_conditional = $(this).closest('.woopt_conditional_item');
    woopt_show_conditional($current_conditional);
    woopt_build_value();
  });

  $(document).on('change', '.woopt_price', function() {
    woopt_build_value();
  });

  $(document).on('change', '.woopt_apply_selector', function() {
    var $current_action = $(this).closest('.woopt_action');
    woopt_show_apply($current_action);
    woopt_build_value();
  });

  $(document).on('change', '.woopt_apply_val', function() {
    woopt_build_value();
  });

  // search category
  $(document).on('change', '.woopt-category-search', function() {
    var _val = $(this).val();

    if (Array.isArray(_val)) {
      $(this).
          closest('.woopt_action').
          find('.woopt_apply_val').
          val(_val.join()).trigger('change');
    } else {
      if (_val === null) {
        $(this).
            closest('.woopt_action').
            find('.woopt_apply_val').
            val('').trigger('change');
      } else {
        $(this).
            closest('.woopt_action').
            find('.woopt_apply_val').
            val(String(_val)).trigger('change');
      }
    }
  });

  $(document).on('click touch', '.woopt_new_conditional', function(e) {
    var $current_conditionals = $(this).
        closest('.woopt_action').
        find('.woopt_conditionals');
    var data = {
      action: 'woopt_add_conditional',
      woopt_nonce: woopt_vars.woopt_nonce,
    };
    $.post(ajaxurl, data, function(response) {
      $current_conditionals.append(response);
      woopt_show_conditional();
    });
    e.preventDefault();
  });

  $(document).on('click touch', '.woopt_action_remove', function() {
    $(this).closest('.woopt_action').remove();
    woopt_build_value();
  });

  $(document).on('click touch', '.woopt_conditional_remove', function() {
    $(this).closest('.woopt_conditional_item').remove();
    woopt_build_value();
  });

  $(document).on('click touch', '.woopt_picker', function() {
    if ($(this).hasClass('woopt_date_time')) {
      $(this).wooptdpk({
        timepicker: true,
        onSelect: function(fd, d) {
          if (!d) {
            return;
          }
          woopt_build_value();
        },
      });
    }
    if ($(this).hasClass('woopt_date')) {
      $(this).wooptdpk({
        onSelect: function(fd, d) {
          if (!d) {
            return;
          }
          woopt_build_value();
        },
      });
    }
    if ($(this).hasClass('woopt_date_range')) {
      $(this).wooptdpk({
        range: true,
        multipleDatesSeparator: ' - ',
        onSelect: function(fd, d) {
          if (!d) {
            return;
          }
          woopt_build_value();
        },
      });
    }
    if ($(this).hasClass('woopt_date_multi')) {
      $(this).wooptdpk({
        multipleDates: 5,
        multipleDatesSeparator: ', ',
        onSelect: function(fd, d) {
          if (!d) {
            return;
          }
          woopt_build_value();
        },
      });
    }
    if ($(this).hasClass('woopt_time')) {
      $(this).wooptdpk({
        timepicker: true,
        onlyTimepicker: true,
        classes: 'only-time',
        onSelect: function(fd, d) {
          if (!d) {
            return;
          }
          woopt_build_value();
        },
      });
    }
  });

  function woopt_time_picker() {
    $('.woopt_date_time').wooptdpk({
      timepicker: true,
      onSelect: function(fd, d) {
        if (!d) {
          return;
        }

        woopt_build_value();
      },
    });
    $('.woopt_date').wooptdpk({
      onSelect: function(fd, d) {
        if (!d) {
          return;
        }

        woopt_build_value();
      },
    });
    $('.woopt_date_range').wooptdpk({
      range: true,
      multipleDatesSeparator: ' - ',
      onSelect: function(fd, d) {
        if (!d) {
          return;
        }

        woopt_build_value();
      },
    });
    $('.woopt_date_multi').wooptdpk({
      multipleDates: 5,
      multipleDatesSeparator: ', ',
      onSelect: function(fd, d) {
        if (!d) {
          return;
        }

        woopt_build_value();
      },
    });
    $('.woopt_time').wooptdpk({
      timepicker: true,
      onlyTimepicker: true,
      classes: 'only-time',
      onSelect: function(fd, d) {
        if (!d) {
          return;
        }

        woopt_build_value();
      },
    });
  }

  function woopt_show_action($current_action) {
    if (typeof $current_action !== 'undefined') {
      var show_field_action = $current_action.find('.woopt_action_selector').
          find(':selected').
          data('show');

      $current_action.find('.woopt_hide').hide();
      $current_action.find('.woopt_show_if_' + show_field_action).show();
    } else {
      $('.woopt_action_td').each(function() {
        var show_field_action = $(this).
            find('.woopt_action_selector').
            find(':selected').
            data('show');

        $(this).find('.woopt_hide').hide();
        $(this).find('.woopt_show_if_' + show_field_action).show();
      });
    }
  }

  function woopt_show_conditional($current_conditional) {
    if (typeof $current_conditional !== 'undefined') {
      var show_field_conditional = $current_conditional.find(
          '.woopt_conditional').find(':selected').data('show');

      $current_conditional.find('.woopt_hide').hide();
      $current_conditional.find('.woopt_show_if_' + show_field_conditional).
          show();
    } else {
      $('.woopt_conditional_item').each(function() {
        var show_field_conditional = $(this).
            find('.woopt_conditional').
            find(':selected').
            data('show');

        $(this).find('.woopt_hide').hide();
        $(this).find('.woopt_show_if_' + show_field_conditional).show();
      });
    }
  }

  function woopt_show_apply($current_action) {
    if (typeof $current_action !== 'undefined') {
      var apply = $current_action.find('.woopt_apply_selector').
          find(':selected').
          val();

      $current_action.find('.hide_apply').hide();
      $current_action.find('.show_if_' + apply).show();
    } else {
      $('.woopt_action').each(function() {
        var apply = $(this).
            find('.woopt_apply_selector').
            find(':selected').
            val();

        $(this).find('.hide_apply').hide();
        $(this).find('.show_if_' + apply).show();
      });
    }
  }

  function woopt_build_value() {
    $('.woopt_action').each(function() {
      var $this = $(this);
      var action = '';
      var conditional = '';
      var conditional_arr = new Array();

      $this.find('.woopt_conditional_item').each(function() {
        var $this_conditional = $(this);
        var current_conditional = $(this).find('.woopt_conditional').val();
        switch (current_conditional) {
          case 'date_range':
            conditional_arr.push(current_conditional + '>' +
                $this_conditional.find('.woopt_date_range').val());
            break;
          case 'date_multi':
            conditional_arr.push(current_conditional + '>' +
                $this_conditional.find('.woopt_date_multi').val());
            break;
          case 'date_on':
            conditional_arr.push(current_conditional + '>' +
                $this_conditional.find('.woopt_date').val());
            break;
          case 'date_before':
            conditional_arr.push(current_conditional + '>' +
                $this_conditional.find('.woopt_date').val());
            break;
          case 'date_after':
            conditional_arr.push(current_conditional + '>' +
                $this_conditional.find('.woopt_date').val());
            break;
          case 'date_time_before':
            conditional_arr.push(current_conditional + '>' +
                $this_conditional.find('.woopt_date_time').val());
            break;
          case 'date_time_after':
            conditional_arr.push(current_conditional + '>' +
                $this_conditional.find('.woopt_date_time').val());
            break;
          case 'date_even':
            conditional_arr.push(current_conditional + '>true');
            break;
          case 'date_odd':
            conditional_arr.push(current_conditional + '>true');
            break;
          case 'time_range':
            conditional_arr.push(current_conditional + '>' +
                $this_conditional.find('.woopt_time_start').val() + ' - ' +
                $this_conditional.find('.woopt_time_end').val());
            break;
          case 'time_before':
            conditional_arr.push(current_conditional + '>' +
                $this_conditional.find('.woopt_time_on').val());
            break;
          case 'time_after':
            conditional_arr.push(current_conditional + '>' +
                $this_conditional.find('.woopt_time_on').val());
            break;
          case 'weekly_every':
            conditional_arr.push(current_conditional + '>' +
                $this_conditional.find('.woopt_weekday').val());
            break;
          case 'week_no':
            conditional_arr.push(current_conditional + '>' +
                $this_conditional.find('.woopt_weekno').val());
            break;
          case 'every_day':
            conditional_arr.push(current_conditional + '>true');
            break;
        }
      });

      conditional = conditional_arr.join('&');

      if ($this.find('.woopt_apply_selector').length) {
        action = $this.find('.woopt_apply_selector').val() + '|' +
            $this.find('.woopt_apply_val').val() + '|' +
            $this.find('.woopt_action_selector').val() + '|' +
            $this.find('.woopt_price').val() + '|' + conditional;
      } else {
        action = $this.find('.woopt_action_selector').val() + '|' +
            $this.find('.woopt_price').val() + '|' + conditional;
      }

      $this.find('.woopt_action_val').val(action);
    });
  }
})(jQuery);