<?php

namespace Zhours\Notification;

defined( 'ABSPATH' ) || exit;

use Zhours\Addons;
use Zhours\Settings;

class Box {

	public function __construct() {
		$this->get_notification();
	}

	public function get_notification() {
		if ( ! apply_filters( 'zh_notification_type_status', true ) ) {
			return;
		}

		$message          = $this->get_setting( 'message' );
		$override_message = apply_filters( 'zhd_get_override_alert_bar_message', null );
		if ( $override_message !== null ) {
			if ( isset( $override_message['checkbox'] ) && $override_message['checkbox'] ) {
				return;
			}
			$message = $override_message['edit'];
		}

		$color         = $this->get_setting( 'color' ) ? $this->get_setting( 'color' ) : 'white';
		$bg_color      = $this->get_setting( 'background color' ) ? $this->get_setting( 'background color' ) : '#e21212';
		$hide_box      = $this->get_setting( 'hide alert bar' );
		$size          = self::get_setting( 'font size' );
		$hide_duration = isset( self::get_setting( 'hide duration' )['sec'] ) ? self::get_setting( 'hide duration' )['sec'] : 10;
		?>
        <div class="zh-notification zh-box" style="display: none;" data-zh-hide-duration="<?= apply_filters( 'zh_box_hide_duration', $hide_duration ) ?>">
            <div class="zh-box__inner" style="color: <?= $color; ?>; background-color: <?= $bg_color; ?>; font-size: <?= $size ?>px;">
				<?php if ( $hide_box && isset( $hide_box['checkbox'] ) ) : ?>
                    <button type="button" class="zh-notification__close zh-box__close">
						<?php if ( isset( $hide_box['edit'] ) && $hide_box['edit'] ) : ?>
                            <span class="zh-box__close-title"><?= $hide_box['edit'] ?></span>
						<?php endif; ?>
                        <span class="zh-box__close-icon zh-icon zh-icon_close"></span>
                    </button>
				<?php endif; ?>
                <div class="zh-box__message">
					<?php if ( ! Addons::is_active_add_on( Addons::ORDER_HOURS_WIDGET_NAMESPACE ) ) : ?>
                        <div class="zh-box__icon">
                            <img src="<?= ZH_ROOT_URL . 'assets/bundles/images/closed-time.png' ?>"
                                 alt="<?= esc_attr__( 'Closed Time', 'order-hours-scheduler-for-woocommerce' ) ?>">
                        </div>
					<?php endif; ?>
					<?php do_action( 'zh_box_icon' ); ?>
					<?= $message; ?>
                </div>
            </div>
        </div>
		<?php
	}

	public static function get_setting( $setting ) {
		return Settings::getValue( 'notification', 'options', $setting );
	}
}
