<?php
defined( 'ABSPATH' ) || exit;
?>
<div class="wc-restaurant-product wc-backbone-modal-content">
    <div class="product-content">
        <# if ( data.image ) { #>
        <header class="image" style="background-image:url({{ data.image }})"></header>
        <# } #>
        <section class="details">
            <h2 class="name">{{ data.product_name }}</h2>
            <# if ( data.description ) { #>
            <div class="description">{{{ data.description }}}</div>
            <# } #>
            <# if ( data.options ) { #>
            <div class="options">{{{ data.options }}}</div>
            <# } #>
        </section>
    </div>
    <footer class="order <# if ( data.in_stock ) { #>purchasable<# } else { #>not-purchasable<# } #>">
        <# if ( data.in_stock ) { #>
        <span class="quantity">
            <button type="button" class="remove" aria-label="<?php esc_attr_e( 'Decrease quantity', 'woocommerce-restaurant-ordering' ); ?>">-</button>
            <input type="number" name="quantity" class="qty" required aria-label="<?php esc_attr_e( 'Enter item quantity', 'woocommerce-restaurant-ordering' ); ?>"
                   value="{{ data.quantity.value }}"
                   min="{{ data.quantity.min }}"
                   max="{{ data.quantity.max }}"
                   step="{{ data.quantity.step }}" />
            <button type="button" class="add" aria-label="<?php esc_attr_e( 'Increase quantity', 'woocommerce-restaurant-ordering' ); ?>">+</button>
        </span>
        <?php echo $buy_button; ?>
        <# } else { #>
        <p class="out-of-stock">
            <?php _e( 'Out of stock', 'woocommerce-restaurant-ordering' ); ?>
        </p>
        <# } #>
    </footer>
</div>