<?php
namespace Barn2\Plugin\WC_Restaurant_Ordering;

use Barn2\WRO_Lib\Registerable,
    Barn2\WRO_Lib\Service,
    Barn2\WRO_Lib\Conditional,
    Barn2\WRO_Lib\Util,
    Barn2\Plugin\WC_Restaurant_Ordering\Menu\Restaurant_Menu,
    Barn2\Plugin\WC_Restaurant_Ordering\Menu\Menu_Options;

/**
 * This class handles the restaurant ordering shortcode.
 *
 * @package
 * @author    Barn2 Plugins <info@barn2.co.uk>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
class Shortcodes implements Registerable, Service, Conditional {

    const MENU_SHORTCODE = 'restaurant_ordering';

    public function is_required() {
        return Util::is_front_end();
    }

    public function register() {
        add_shortcode( self::MENU_SHORTCODE, [ $this, 'menu_shortcode' ] );
    }

    public function menu_shortcode( $atts, $content = '' ) {
        $args = shortcode_atts( Menu_Options::get_defaults(), $atts, self::MENU_SHORTCODE );
        $menu = new Restaurant_Menu( new Menu_Options( $args ) );

        // Return the table as HTML.
        return $menu->get_menu();
    }

}
