<?php
namespace Barn2\Plugin\WC_Restaurant_Ordering\Rest;

use WP_Error;

/**
 *
 * @package   Barn2\
 * @author    Barn2 Plugins <support@barn2.co.uk>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
class Rest_Util {

    public static function validate_product( $product_id ) {
        $product_id = absint( $product_id );
        $product    = wc_get_product( $product_id );

        // Check product exists.
        if ( ! $product ) {
            return new WP_Error( 'rest_invalid_product_id', esc_html__( 'The product does not exist.', 'woocommerce-restaurant-ordering' ), [
                'status' => 400 ] );
        }

        // Check product is visible in shop.
        if ( ! apply_filters( 'wc_restaurant_ordering_show_hidden_products', false ) && ! $product->is_visible() ) {
            return new WP_Error( 'rest_product_not_visible', esc_html__( 'This product is not visible.', 'woocommerce-restaurant-ordering' ), [
                'status' => 400 ] );
        }

        if ( ! $product->is_purchasable() ) {
            return new WP_Error( 'rest_product_not_purchasable', esc_html__( 'The product cannot be purchased.', 'woocommerce-restaurant-ordering' ), [
                'status' => 400 ] );
        }

        return $product;
    }

    public static function validate_product_params( array $params ) {
        $params = array_merge( [
            'product_id' => 0
            ], $params );

        $product_id = absint( $params['product_id'] );
        $product    = self::validate_product( $product_id );

        if ( $product instanceof WP_Error ) {
            return $product;
        }

        return [
            'product_id' => $product_id,
            'product'    => $product
        ];
    }

    public static function get_order_error_message( WP_Error $error ) {
        return __( 'Sorry, this item is not available.', 'woocommerce-restaurant-ordering' );
    }

}
