<?php
namespace Barn2\Plugin\WC_Restaurant_Ordering\Integrations;

use Barn2\WRO_Lib\Registerable,
    Barn2\WRO_Lib\Util,
    Barn2\Plugin\WC_Product_Table\Frontend_Scripts;

/**
 * WooCommerce Product Table integration.
 *
 * @package   Barn2\woocommerce-restaurant-ordering
 * @author    Barn2 Plugins <support@barn2.co.uk>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
class Product_Table implements Registerable {

    public function register() {
        if ( Util::is_product_table_active() ) {
            add_action( 'wp_enqueue_scripts', [ $this, 'load_table_scripts' ], 30 );
        }
    }

    public function load_table_scripts() {
        wp_enqueue_style( Frontend_Scripts::SCRIPT_HANDLE );
        wp_enqueue_script( Frontend_Scripts::SCRIPT_HANDLE );
    }

}
