<?php
namespace Barn2\Plugin\WC_Restaurant_Ordering\Admin;

use Barn2\Plugin\WC_Restaurant_Ordering\Shortcodes,
    Barn2\WRO_Lib\Plugin\Plugin_Activation_Listener,
    Barn2\WRO_Lib\Registerable;

/**
 * Sets up the plugin on install.
 *
 * @package   Barn2\woocommerce-restaurant-ordering
 * @author    Barn2 Plugins <support@barn2.co.uk>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
class Plugin_Setup implements Plugin_Activation_Listener, Registerable {

    private $file;

    public function __construct( $file ) {
        $this->file = $file;
    }

    public function register() {
        register_activation_hook( $this->file, [ $this, 'on_activate' ] );
    }

    public function on_activate() {
        $this->setup();
    }

    public function on_deactivate() {
        // We do, nothing.
    }

    public function setup() {
        $page_id = $this->create_restaurant_page();

        if ( $page_id ) {
            $this->set_restaurant_page_setting( $page_id );
        }
    }

    private function create_restaurant_page() {
        // Bail if we've already created the page or if order page has been selected in settings.
        if ( get_option( 'wro_restaurant_page_created', false ) || get_option( 'wro_menu_page', false ) ) {
            return false;
        }

        $page_id = wp_insert_post( [
            'post_title'   => __( 'Restaurant Order', 'woocommerce-restaurant-ordering' ),
            'post_content' => '[' . Shortcodes::MENU_SHORTCODE . ']',
            'post_status'  => 'publish',
            'post_type'    => 'page'
            ] );

        if ( $page_id && ! is_wp_error( $page_id ) ) {
            update_option( 'wro_restaurant_page_created', true, 'no' );
            return $page_id;
        }

        return false;
    }

    private function set_restaurant_page_setting( $page_id ) {
        update_option( 'wro_menu_page', $page_id, 'no' );
    }

}
