<?php
namespace Barn2\Plugin\WC_Restaurant_Ordering\Admin;

use Barn2\WRO_Lib\Registerable,
    Barn2\WRO_Lib\Service,
    Barn2\WRO_Lib\Conditional,
    Barn2\WRO_Lib\Plugin\Licensed_Plugin,
    Barn2\WRO_Lib\Util,
    Barn2\WRO_Lib\Plugin\Admin\Admin_Links;

/**
 * Handles the admin configuration.
 *
 * @package   Barn2\woocommerce-restaurant-ordering
 * @author    Barn2 Plugins <support@barn2.co.uk>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
class Admin_Controller implements Registerable, Conditional, Service {

    private $plugin;
    private $services = [];

    public function __construct( Licensed_Plugin $plugin ) {
        $this->plugin   = $plugin;
        $this->services = [
            new Admin_Links( $plugin )
        ];
    }

    public function is_required() {
        return Util::is_admin();
    }

    public function register() {
        Util::register_services( $this->services );

        // Add settings page.
        add_filter( 'woocommerce_get_settings_pages', array( $this, 'add_settings_page' ), 20 );
    }

    public function add_settings_page( $settings ) {
        $settings_page = new Settings_Page( $this->plugin );
        $settings_page->register();

        $settings = $settings_page;
        return $settings;
    }

}
