( function( $, window, document, _ ) {
    'use strict';

    // Re-order options in a <select> based on the current order in the select2 container.
    function reorderMultiSelect( $multiSelect, $selection ) {
        $selection.children( 'li[title]' ).get().reverse().forEach( function( obj ) {
            let $option = $multiSelect.children( 'option' ).filter( function() {
                return $( this ).html() === _.escape( obj.title );
            } );

            $option.detach();
            $multiSelect.prepend( $option );
        } );
    }

    $( document ).ready( function() {
        let $categories = $( '#wro_categories' );

        // Initialize select2 for categories.
        $categories
            .selectWoo( {
                dropdownCssClass: 'categories-dropdown'
            } );

        let $categorySelection = $categories
            .siblings( '.select2' )
            .find( '.select2-selection__rendered' );

        // Bind select2 events.
        $categories
            .on( 'select2:select select2:unselect', function( event ) {
                reorderMultiSelect( $categories, $categorySelection );
            } );

        // Make select2 selections sortable.
        $categorySelection
            .sortable( {
                axis: 'y',
                update: function() {
                    reorderMultiSelect( $categories, $( this ) );
                }
            } );

        $( '#wro_menu_page' ).selectWoo( {
            allowClear: true
        } );

    } );

} )( jQuery, window, document, _ );
